/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.parser.api;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;

public class YangSyntaxErrorException
extends YangParserException {
    private static final long serialVersionUID = 2L;
    private final SourceIdentifier source;
    private final int line;
    private final int charPositionInLine;

    public YangSyntaxErrorException(@Nullable SourceIdentifier source, int line, int charPositionInLine, String message) {
        this(source, line, charPositionInLine, message, null);
    }

    public YangSyntaxErrorException(@Nullable SourceIdentifier source, int line, int charPositionInLine, String message, @Nullable Throwable cause) {
        super(message, cause);
        this.source = source;
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public final Optional<SourceIdentifier> getSource() {
        return Optional.ofNullable(this.source);
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public @NonNull String getFormattedMessage() {
        StringBuilder sb = new StringBuilder(this.getMessage());
        if (this.source != null) {
            sb.append(" in source ");
            sb.append(this.source);
        }
        if (this.line != 0) {
            sb.append(" on line ");
            sb.append(this.line);
            if (this.charPositionInLine != 0) {
                sb.append(" character ");
                sb.append(this.charPositionInLine);
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getFormattedMessage();
    }
}

