/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public class ProxySchemaContext
implements SchemaContext {
    private final SchemaContextProvider schemaProvider;

    public ProxySchemaContext(SchemaContextProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    private SchemaContext getCurrentSchema() {
        Preconditions.checkState((this.schemaProvider.getSchemaContext() != null ? 1 : 0) != 0, (String)"Schema context unavailable from %s", (Object)this.schemaProvider);
        return this.schemaProvider.getSchemaContext();
    }

    public Set<DataSchemaNode> getDataDefinitions() {
        return this.getCurrentSchema().getDataDefinitions();
    }

    public Set<Module> getModules() {
        return this.getCurrentSchema().getModules();
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.getCurrentSchema().getNotifications();
    }

    public Set<RpcDefinition> getOperations() {
        return this.getCurrentSchema().getOperations();
    }

    public Set<ExtensionDefinition> getExtensions() {
        return this.getCurrentSchema().getExtensions();
    }

    public boolean isPresenceContainer() {
        return this.getCurrentSchema().isPresenceContainer();
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.getCurrentSchema().getTypeDefinitions();
    }

    public Collection<DataSchemaNode> getChildNodes() {
        return this.getCurrentSchema().getChildNodes();
    }

    public Set<GroupingDefinition> getGroupings() {
        return this.getCurrentSchema().getGroupings();
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return this.getCurrentSchema().findDataChildByName(name);
    }

    public Set<UsesNode> getUses() {
        return this.getCurrentSchema().getUses();
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return this.getCurrentSchema().getAvailableAugmentations();
    }

    public boolean isAugmenting() {
        return this.getCurrentSchema().isAugmenting();
    }

    public boolean isAddedByUses() {
        return this.getCurrentSchema().isAddedByUses();
    }

    public boolean isConfiguration() {
        return this.getCurrentSchema().isConfiguration();
    }

    public QName getQName() {
        return this.getCurrentSchema().getQName();
    }

    public SchemaPath getPath() {
        return this.getCurrentSchema().getPath();
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.getCurrentSchema().getUnknownSchemaNodes();
    }

    public Optional<String> getDescription() {
        return this.getCurrentSchema().getDescription();
    }

    public Optional<String> getReference() {
        return this.getCurrentSchema().getReference();
    }

    public Status getStatus() {
        return this.getCurrentSchema().getStatus();
    }

    public Optional<Module> findModule(String name, Optional<Revision> revision) {
        return this.getCurrentSchema().findModule(name, revision);
    }

    public Optional<Module> findModule(QNameModule qnameModule) {
        return this.getCurrentSchema().findModule(qnameModule);
    }
}

