/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl.mount;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.controller.md.sal.dom.broker.spi.mount.SimpleDOMMountPoint;
import org.opendaylight.controller.sal.core.compat.DOMDataBrokerAdapter;
import org.opendaylight.controller.sal.core.compat.DOMMountPointAdapter;
import org.opendaylight.controller.sal.core.compat.DOMNotificationServiceAdapter;
import org.opendaylight.controller.sal.core.compat.DOMRpcServiceAdapter;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class DOMMountPointServiceImpl
implements DOMMountPointService {
    private static final Map<Class<? extends DOMService>, CompatFactory<?, ?>> KNOWN_SERVICES = ImmutableMap.of(org.opendaylight.controller.md.sal.dom.api.DOMActionService.class, (Object)new CompatFactory<DOMActionService, org.opendaylight.controller.md.sal.dom.api.DOMActionService>(org.opendaylight.controller.md.sal.dom.api.DOMActionService.class, DOMActionService.class){

        @Override
        DOMActionService createService(org.opendaylight.controller.md.sal.dom.api.DOMActionService delegate) {
            return delegate;
        }
    }, DOMDataBroker.class, (Object)new CompatFactory<org.opendaylight.mdsal.dom.api.DOMDataBroker, DOMDataBroker>(DOMDataBroker.class, org.opendaylight.mdsal.dom.api.DOMDataBroker.class){

        @Override
        org.opendaylight.mdsal.dom.api.DOMDataBroker createService(DOMDataBroker delegate) {
            return new DOMDataBrokerAdapter(delegate);
        }
    }, DOMNotificationService.class, (Object)new CompatFactory<org.opendaylight.mdsal.dom.api.DOMNotificationService, DOMNotificationService>(DOMNotificationService.class, org.opendaylight.mdsal.dom.api.DOMNotificationService.class){

        @Override
        org.opendaylight.mdsal.dom.api.DOMNotificationService createService(DOMNotificationService delegate) {
            return new DOMNotificationServiceAdapter(delegate);
        }
    }, DOMRpcService.class, (Object)new CompatFactory<org.opendaylight.mdsal.dom.api.DOMRpcService, DOMRpcService>(DOMRpcService.class, org.opendaylight.mdsal.dom.api.DOMRpcService.class){

        @Override
        org.opendaylight.mdsal.dom.api.DOMRpcService createService(DOMRpcService delegate) {
            return new DOMRpcServiceAdapter(delegate);
        }
    });
    private final org.opendaylight.mdsal.dom.api.DOMMountPointService delegate;

    @VisibleForTesting
    public DOMMountPointServiceImpl() {
        this((org.opendaylight.mdsal.dom.api.DOMMountPointService)new org.opendaylight.mdsal.dom.broker.DOMMountPointServiceImpl());
    }

    public DOMMountPointServiceImpl(org.opendaylight.mdsal.dom.api.DOMMountPointService delegate) {
        this.delegate = delegate;
    }

    public Optional<DOMMountPoint> getMountPoint(YangInstanceIdentifier path) {
        return Optional.fromJavaUtil(this.delegate.getMountPoint(path).map(DOMMountPointAdapter::new));
    }

    public DOMMountPointService.DOMMountPointBuilder createMountPoint(YangInstanceIdentifier path) {
        return new DOMMountPointBuilderImpl(path);
    }

    public ListenerRegistration<DOMMountPointListener> registerProvisionListener(DOMMountPointListener listener) {
        return this.delegate.registerProvisionListener(listener);
    }

    ObjectRegistration<DOMMountPoint> registerMountPoint(SimpleDOMMountPoint mountPoint) {
        DOMMountPointService.DOMMountPointBuilder delegateBuilder = this.delegate.createMountPoint(mountPoint.getIdentifier());
        if (mountPoint.getSchemaContext() != null) {
            delegateBuilder.addInitialSchemaContext(mountPoint.getSchemaContext());
        }
        ClassToInstanceMap myServices = mountPoint.getServices();
        for (Map.Entry entry : myServices.entrySet()) {
            delegateBuilder.addService((Class)entry.getKey(), (org.opendaylight.mdsal.dom.api.DOMService)entry.getValue());
            CompatFactory<?, ?> compat = KNOWN_SERVICES.get(entry.getKey());
            if (compat == null) continue;
            compat.addService(delegateBuilder, (ClassToInstanceMap<DOMService>)myServices);
        }
        final ObjectRegistration delegateReg = delegateBuilder.register();
        return new AbstractObjectRegistration<DOMMountPoint>((DOMMountPoint)mountPoint){

            protected void removeRegistration() {
                delegateReg.close();
            }
        };
    }

    public class DOMMountPointBuilderImpl
    implements DOMMountPointService.DOMMountPointBuilder {
        private final ClassToInstanceMap<DOMService> services = MutableClassToInstanceMap.create();
        private final YangInstanceIdentifier path;
        private SimpleDOMMountPoint mountPoint;
        private SchemaContext schemaContext;

        public DOMMountPointBuilderImpl(YangInstanceIdentifier path) {
            this.path = path;
        }

        public <T extends DOMService> DOMMountPointService.DOMMountPointBuilder addService(Class<T> type, T impl) {
            this.services.putInstance(type, impl);
            return this;
        }

        public DOMMountPointService.DOMMountPointBuilder addInitialSchemaContext(SchemaContext ctx) {
            this.schemaContext = ctx;
            return this;
        }

        public ObjectRegistration<DOMMountPoint> register() {
            Preconditions.checkState((this.mountPoint == null ? 1 : 0) != 0, (Object)"Mount point is already built.");
            this.mountPoint = SimpleDOMMountPoint.create((YangInstanceIdentifier)this.path, this.services, (SchemaContext)this.schemaContext);
            return DOMMountPointServiceImpl.this.registerMountPoint(this.mountPoint);
        }
    }

    private static abstract class CompatFactory<M extends org.opendaylight.mdsal.dom.api.DOMService, C extends DOMService> {
        private final Class<C> controllerClass;
        private final Class<M> mdsalClass;

        CompatFactory(Class<C> controllerClass, Class<M> mdsalClass) {
            this.controllerClass = Objects.requireNonNull(controllerClass);
            this.mdsalClass = Objects.requireNonNull(mdsalClass);
        }

        final void addService(DOMMountPointService.DOMMountPointBuilder builder, ClassToInstanceMap<DOMService> services) {
            M mdsalService;
            DOMService controllerService;
            if (!services.containsKey(this.mdsalClass) && (controllerService = (DOMService)services.getInstance(this.controllerClass)) != null && (mdsalService = this.createService(controllerService)) != null) {
                builder.addService(this.mdsalClass, mdsalService);
            }
        }

        abstract M createService(C var1);
    }
}

