/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter.ShardedDOMDataBrokerDelegatingReadTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter.ShardedDOMDataBrokerDelegatingReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter.ShardedDOMDataBrokerDelegatingWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

class ShardedDOMDataBrokerDelegatingTransactionChain
implements org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain,
DOMTransactionChainListener {
    private final DOMTransactionChain txChainDelegate;
    private final SchemaContext schemaContext;
    private final TransactionChainListener txChainListener;
    private final Object txChainIdentifier;
    private final AtomicLong txNum = new AtomicLong();
    private final Map<Object, AsyncTransaction<?, ?>> transactionMap;

    ShardedDOMDataBrokerDelegatingTransactionChain(Object txChainIdentifier, SchemaContext schemaContext, DOMDataBroker brokerDelegate, TransactionChainListener txChainListener) {
        Objects.requireNonNull(brokerDelegate);
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.txChainIdentifier = Objects.requireNonNull(txChainIdentifier);
        this.txChainListener = Objects.requireNonNull(txChainListener);
        this.txChainDelegate = brokerDelegate.createTransactionChain((DOMTransactionChainListener)this);
        this.transactionMap = Maps.newHashMap();
    }

    public DOMDataReadOnlyTransaction newReadOnlyTransaction() {
        DOMDataTreeReadTransaction readTxDelegate = this.txChainDelegate.newReadOnlyTransaction();
        ShardedDOMDataBrokerDelegatingReadTransaction readTx = new ShardedDOMDataBrokerDelegatingReadTransaction(this.newTransactionIdentifier(), readTxDelegate);
        this.transactionMap.put(readTxDelegate.getIdentifier(), (AsyncTransaction<?, ?>)readTx);
        return readTx;
    }

    public DOMDataReadWriteTransaction newReadWriteTransaction() {
        Object readWriteTxId = this.newTransactionIdentifier();
        DOMDataTreeReadTransaction readTxDelegate = this.txChainDelegate.newReadOnlyTransaction();
        ShardedDOMDataBrokerDelegatingReadTransaction readTx = new ShardedDOMDataBrokerDelegatingReadTransaction(readWriteTxId, readTxDelegate);
        DOMDataTreeWriteTransaction writeTxDelegate = this.txChainDelegate.newWriteOnlyTransaction();
        ShardedDOMDataBrokerDelegatingWriteTransaction writeTx = new ShardedDOMDataBrokerDelegatingWriteTransaction(readWriteTxId, writeTxDelegate);
        ShardedDOMDataBrokerDelegatingReadWriteTransaction readWriteTx = new ShardedDOMDataBrokerDelegatingReadWriteTransaction(readWriteTxId, this.schemaContext, readTx, writeTx);
        this.transactionMap.put(readTxDelegate.getIdentifier(), (AsyncTransaction<?, ?>)readWriteTx);
        this.transactionMap.put(writeTxDelegate.getIdentifier(), (AsyncTransaction<?, ?>)readWriteTx);
        return readWriteTx;
    }

    public DOMDataWriteTransaction newWriteOnlyTransaction() {
        DOMDataTreeWriteTransaction writeTxDelegate = this.txChainDelegate.newWriteOnlyTransaction();
        ShardedDOMDataBrokerDelegatingWriteTransaction writeTx = new ShardedDOMDataBrokerDelegatingWriteTransaction(this.newTransactionIdentifier(), writeTxDelegate);
        this.transactionMap.put(writeTxDelegate.getIdentifier(), (AsyncTransaction<?, ?>)writeTx);
        return writeTx;
    }

    public void close() {
        this.txChainDelegate.close();
    }

    public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
        this.txChainListener.onTransactionChainFailed((TransactionChain)this, this.transactionFromDelegate(transaction.getIdentifier()), cause);
    }

    public void onTransactionChainSuccessful(DOMTransactionChain chain) {
        this.txChainListener.onTransactionChainSuccessful((TransactionChain)this);
    }

    private AsyncTransaction<?, ?> transactionFromDelegate(Object delegateId) {
        Preconditions.checkState((boolean)this.transactionMap.containsKey(delegateId), (String)"Delegate transaction {} is not present in transaction chain history", (Object)delegateId);
        return this.transactionMap.get(delegateId);
    }

    private Object newTransactionIdentifier() {
        return "DOM-CHAIN-" + this.txChainIdentifier + "-" + this.txNum.getAndIncrement();
    }
}

