/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@NotThreadSafe
class ShardedDOMDataBrokerDelegatingReadWriteTransaction
implements DOMDataReadWriteTransaction {
    private final DOMDataReadOnlyTransaction readTxDelegate;
    private final DOMDataWriteTransaction writeTxDelegate;
    private final Object txIdentifier;
    private final ImmutableMap<LogicalDatastoreType, Queue<Modification>> modificationHistoryMap;
    private final ImmutableMap<LogicalDatastoreType, DataTreeSnapshot> snapshotMap;
    private final Map<LogicalDatastoreType, ListenableFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>>> initialReadMap;
    private YangInstanceIdentifier root = null;

    ShardedDOMDataBrokerDelegatingReadWriteTransaction(Object readWriteTxId, SchemaContext ctx, DOMDataReadOnlyTransaction readTxDelegate, DOMDataWriteTransaction writeTxDelegate) {
        this.readTxDelegate = Objects.requireNonNull(readTxDelegate);
        this.writeTxDelegate = Objects.requireNonNull(writeTxDelegate);
        this.txIdentifier = Objects.requireNonNull(readWriteTxId);
        this.initialReadMap = Maps.newEnumMap(LogicalDatastoreType.class);
        InMemoryDataTreeFactory treeFactory = new InMemoryDataTreeFactory();
        ImmutableMap.Builder snapshotMapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder modificationHistoryMapBuilder = ImmutableMap.builder();
        for (LogicalDatastoreType store : LogicalDatastoreType.values()) {
            DataTree tree = treeFactory.create(ShardedDOMDataBrokerDelegatingReadWriteTransaction.treeConfigForStore(store));
            tree.setSchemaContext(ctx);
            snapshotMapBuilder.put((Object)store, (Object)tree.takeSnapshot());
            modificationHistoryMapBuilder.put((Object)store, (Object)Lists.newLinkedList());
        }
        this.modificationHistoryMap = modificationHistoryMapBuilder.build();
        this.snapshotMap = snapshotMapBuilder.build();
    }

    public boolean cancel() {
        this.readTxDelegate.close();
        return this.writeTxDelegate.cancel();
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        if (this.root == null) {
            this.initialRead(path);
        }
        ((Queue)this.modificationHistoryMap.get((Object)store)).add(new Modification(Modification.Operation.DELETE, path, null));
        this.writeTxDelegate.delete(store, path);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return this.writeTxDelegate.commit();
    }

    public CheckedFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>, ReadFailedException> read(final LogicalDatastoreType store, final YangInstanceIdentifier path) {
        Preconditions.checkState((this.root != null ? 1 : 0) != 0, (Object)"A modify operation (put, merge or delete) must be performed prior to a read operation");
        final SettableFuture readResult = SettableFuture.create();
        final LinkedList currentHistory = Lists.newLinkedList((Iterable)((Iterable)this.modificationHistoryMap.get((Object)store)));
        Futures.addCallback(this.initialReadMap.get(store), (FutureCallback)new FutureCallback<com.google.common.base.Optional<NormalizedNode<?, ?>>>(){

            public void onSuccess(com.google.common.base.Optional<NormalizedNode<?, ?>> result) {
                DataTreeModification mod = ((DataTreeSnapshot)ShardedDOMDataBrokerDelegatingReadWriteTransaction.this.snapshotMap.get((Object)store)).newModification();
                if (result.isPresent()) {
                    mod.write(path, (NormalizedNode)result.get());
                }
                ShardedDOMDataBrokerDelegatingReadWriteTransaction.applyModificationHistoryToSnapshot(mod, currentHistory);
                readResult.set((Object)com.google.common.base.Optional.fromJavaUtil((Optional)mod.readNode(path)));
            }

            public void onFailure(Throwable throwable) {
                readResult.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return Futures.makeChecked((ListenableFuture)readResult, (Function)ReadFailedException.MAPPER);
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        Preconditions.checkState((this.root != null ? 1 : 0) != 0, (Object)"A modify operation (put, merge or delete) must be performed prior to an exists operation");
        return Futures.makeChecked((ListenableFuture)Futures.transform(this.read(store, path), com.google.common.base.Optional::isPresent, (Executor)MoreExecutors.directExecutor()), (Function)ReadFailedException.MAPPER);
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        if (this.root == null) {
            this.initialRead(path);
        }
        ((Queue)this.modificationHistoryMap.get((Object)store)).add(new Modification(Modification.Operation.WRITE, path, data));
        this.writeTxDelegate.put(store, path, data);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        if (this.root == null) {
            this.initialRead(path);
        }
        ((Queue)this.modificationHistoryMap.get((Object)store)).add(new Modification(Modification.Operation.MERGE, path, data));
        this.writeTxDelegate.merge(store, path, data);
    }

    public Object getIdentifier() {
        return this.txIdentifier;
    }

    private void initialRead(YangInstanceIdentifier path) {
        this.root = path;
        for (LogicalDatastoreType store : LogicalDatastoreType.values()) {
            this.initialReadMap.put(store, (ListenableFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>>)this.readTxDelegate.read(store, path));
        }
    }

    private static DataTreeConfiguration treeConfigForStore(LogicalDatastoreType store) {
        return store == LogicalDatastoreType.CONFIGURATION ? DataTreeConfiguration.DEFAULT_CONFIGURATION : DataTreeConfiguration.DEFAULT_OPERATIONAL;
    }

    private static void applyModificationHistoryToSnapshot(DataTreeModification dataTreeModification, Queue<Modification> modificationHistory) {
        while (!modificationHistory.isEmpty()) {
            Modification modification = modificationHistory.poll();
            switch (modification.getOperation()) {
                case WRITE: {
                    dataTreeModification.write(modification.getPath(), modification.getData());
                    break;
                }
                case MERGE: {
                    dataTreeModification.merge(modification.getPath(), modification.getData());
                    break;
                }
                case DELETE: {
                    dataTreeModification.delete(modification.getPath());
                    break;
                }
            }
        }
    }

    static class Modification {
        private final NormalizedNode<?, ?> data;
        private final YangInstanceIdentifier path;
        private final Operation operation;

        Modification(Operation operation, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
            this.data = data;
            this.path = Objects.requireNonNull(path);
            this.operation = Objects.requireNonNull(operation);
        }

        Operation getOperation() {
            return this.operation;
        }

        YangInstanceIdentifier getPath() {
            return this.path;
        }

        NormalizedNode<?, ?> getData() {
            return this.data;
        }

        static enum Operation {
            WRITE,
            MERGE,
            DELETE;

        }
    }
}

