/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMDataBroker;
import org.opendaylight.controller.md.sal.dom.broker.impl.CommitCoordinationTask;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedDOMDataBroker
extends AbstractDOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(SerializedDOMDataBroker.class);
    private final DurationStatisticsTracker commitStatsTracker = DurationStatisticsTracker.createConcurrent();
    private final ListeningExecutorService executor;

    public SerializedDOMDataBroker(Map<LogicalDatastoreType, DOMStore> datastores, ListeningExecutorService executor) {
        super(datastores);
        this.executor = (ListeningExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor must not be null.");
    }

    public DurationStatisticsTracker getCommitStatsTracker() {
        return this.commitStatsTracker;
    }

    @Override
    protected <T> ListenableFuture<T> commit(DOMDataWriteTransaction transaction, Collection<DOMStoreThreePhaseCommitCohort> cohorts, Supplier<T> futureValueSupplier) {
        ListenableFuture commitFuture;
        Preconditions.checkArgument((transaction != null ? 1 : 0) != 0, (Object)"Transaction must not be null.");
        Preconditions.checkArgument((cohorts != null ? 1 : 0) != 0, (Object)"Cohorts must not be null.");
        LOG.debug("Tx: {} is submitted for execution.", transaction.getIdentifier());
        try {
            commitFuture = this.executor.submit(new CommitCoordinationTask<T>(transaction, cohorts, this.commitStatsTracker, futureValueSupplier));
        }
        catch (RejectedExecutionException e) {
            LOG.error("The commit executor {} queue is full - submit task was rejected. \n", (Object)this.executor, (Object)e);
            commitFuture = Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("Could not submit the commit task - the commit queue capacity has been exceeded.", (Throwable)e, new RpcError[0]));
        }
        return commitFuture;
    }
}

