/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;

final class PingPongTransaction
implements FutureCallback<CommitInfo> {
    private final DOMDataReadWriteTransaction delegate;
    private final SettableFuture<CommitInfo> future;
    private DOMDataReadWriteTransaction frontendTransaction;

    PingPongTransaction(DOMDataReadWriteTransaction delegate) {
        this.delegate = (DOMDataReadWriteTransaction)Preconditions.checkNotNull((Object)delegate);
        this.future = SettableFuture.create();
    }

    DOMDataReadWriteTransaction getTransaction() {
        return this.delegate;
    }

    DOMDataReadWriteTransaction getFrontendTransaction() {
        return this.frontendTransaction;
    }

    ListenableFuture<CommitInfo> getCommitFuture() {
        return this.future;
    }

    public void onSuccess(CommitInfo result) {
        this.future.set((Object)result);
    }

    public void onFailure(Throwable throwable) {
        this.future.setException(throwable);
    }

    void recordFrontendTransaction(DOMDataReadWriteTransaction tx) {
        if (this.frontendTransaction != null) {
            this.frontendTransaction = tx;
        }
    }

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("delegate", (Object)this.delegate);
    }
}

