/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.spi.AbstractDOMRpcImplementationRegistration;
import org.opendaylight.controller.sal.core.compat.DOMRpcServiceAdapter;
import org.opendaylight.controller.sal.core.compat.LegacyDOMRpcResultFutureAdapter;
import org.opendaylight.controller.sal.core.compat.MdsalDOMRpcResultFutureAdapter;
import org.opendaylight.controller.sal.core.compat.RpcAvailabilityListenerAdapter;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class DOMRpcRouter
implements AutoCloseable,
DOMRpcService,
DOMRpcProviderService,
SchemaContextListener {
    private final Map<org.opendaylight.mdsal.dom.api.DOMRpcImplementation, DOMRpcImplementation> implMapping = Collections.synchronizedMap(new WeakHashMap());
    private final org.opendaylight.mdsal.dom.api.DOMRpcService delegateRpcService;
    private final org.opendaylight.mdsal.dom.api.DOMRpcProviderService delegateRpcProviderService;
    private final SchemaContextListener delegateSchemaContextListener;

    @VisibleForTesting
    public DOMRpcRouter() {
        org.opendaylight.mdsal.dom.broker.DOMRpcRouter delegate = new org.opendaylight.mdsal.dom.broker.DOMRpcRouter();
        this.delegateRpcService = delegate.getRpcService();
        this.delegateRpcProviderService = delegate.getRpcProviderService();
        this.delegateSchemaContextListener = delegate;
    }

    public DOMRpcRouter(org.opendaylight.mdsal.dom.api.DOMRpcService delegateRpcService, org.opendaylight.mdsal.dom.api.DOMRpcProviderService delegateRpcProviderService) {
        this.delegateRpcService = delegateRpcService;
        this.delegateRpcProviderService = delegateRpcProviderService;
        this.delegateSchemaContextListener = null;
    }

    public <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(T implementation, org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier ... rpcs) {
        return this.registerRpcImplementation(implementation, (Set<org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier>)ImmutableSet.copyOf((Object[])rpcs));
    }

    public synchronized <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(final T implementation, Set<org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier> rpcs) {
        final org.opendaylight.mdsal.dom.api.DOMRpcImplementation delegateImpl = new org.opendaylight.mdsal.dom.api.DOMRpcImplementation(){

            public FluentFuture<org.opendaylight.mdsal.dom.api.DOMRpcResult> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
                return new MdsalDOMRpcResultFutureAdapter(implementation.invokeRpc(org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier.fromMdsal((DOMRpcIdentifier)rpc), input));
            }

            public long invocationCost() {
                return implementation.invocationCost();
            }
        };
        this.implMapping.put(delegateImpl, implementation);
        final org.opendaylight.mdsal.dom.api.DOMRpcImplementationRegistration reg = this.delegateRpcProviderService.registerRpcImplementation(delegateImpl, DOMRpcServiceAdapter.convert(rpcs));
        return new AbstractDOMRpcImplementationRegistration<T>(implementation){

            protected void removeRegistration() {
                reg.close();
                DOMRpcRouter.this.implMapping.remove(delegateImpl);
            }
        };
    }

    public CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(SchemaPath type, NormalizedNode<?, ?> input) {
        FluentFuture future = this.delegateRpcService.invokeRpc(type, input);
        return future instanceof MdsalDOMRpcResultFutureAdapter ? (CheckedFuture)((MdsalDOMRpcResultFutureAdapter)future).delegate() : new LegacyDOMRpcResultFutureAdapter(future);
    }

    public synchronized <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(T listener) {
        final ListenerRegistration reg = this.delegateRpcService.registerRpcListener((org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener)new RpcAvailabilityListenerAdapter<T>(listener){

            public boolean acceptsImplementation(org.opendaylight.mdsal.dom.api.DOMRpcImplementation impl) {
                DOMRpcImplementation legacyImpl = (DOMRpcImplementation)DOMRpcRouter.this.implMapping.get(impl);
                return legacyImpl != null ? this.delegate().acceptsImplementation(legacyImpl) : true;
            }
        });
        return new AbstractListenerRegistration<T>(listener){

            protected void removeRegistration() {
                reg.close();
            }
        };
    }

    @Override
    public void close() {
    }

    @VisibleForTesting
    public void onGlobalContextUpdated(SchemaContext context) {
        if (this.delegateSchemaContextListener != null) {
            this.delegateSchemaContextListener.onGlobalContextUpdated(context);
        }
    }
}

