/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMForwardedCompositeTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMForwardedTransactionFactory;
import org.opendaylight.controller.md.sal.dom.broker.impl.TransactionCommitFailedExceptionMapper;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DOMForwardedWriteTransaction<T extends DOMStoreWriteTransaction>
extends AbstractDOMForwardedCompositeTransaction<LogicalDatastoreType, T>
implements DOMDataWriteTransaction {
    private static final AtomicReferenceFieldUpdater<DOMForwardedWriteTransaction, AbstractDOMForwardedTransactionFactory> IMPL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DOMForwardedWriteTransaction.class, AbstractDOMForwardedTransactionFactory.class, "commitImpl");
    private static final AtomicReferenceFieldUpdater<DOMForwardedWriteTransaction, Future> FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DOMForwardedWriteTransaction.class, Future.class, "commitFuture");
    private static final Logger LOG = LoggerFactory.getLogger(DOMForwardedWriteTransaction.class);
    private static final Future<?> CANCELLED_FUTURE = Futures.immediateCancelledFuture();
    private volatile AbstractDOMForwardedTransactionFactory<?> commitImpl;
    private volatile Future<?> commitFuture;

    protected DOMForwardedWriteTransaction(Object identifier, Map<LogicalDatastoreType, T> backingTxs, AbstractDOMForwardedTransactionFactory<?> commitImpl) {
        super(identifier, backingTxs);
        this.commitImpl = (AbstractDOMForwardedTransactionFactory)Preconditions.checkNotNull(commitImpl, (Object)"commitImpl must not be null.");
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkRunning(this.commitImpl);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).write(path, data);
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkRunning(this.commitImpl);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).delete(path);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkRunning(this.commitImpl);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).merge(path, data);
    }

    public boolean cancel() {
        Future<?> future;
        AbstractDOMForwardedTransactionFactory impl = IMPL_UPDATER.getAndSet(this, null);
        if (impl != null) {
            LOG.trace("Transaction {} cancelled before submit", this.getIdentifier());
            FUTURE_UPDATER.lazySet(this, CANCELLED_FUTURE);
            this.closeSubtransactions();
            return true;
        }
        while ((future = this.commitFuture) == null) {
        }
        return future.cancel(false);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return FluentFuture.from(this.doCommit(CommitInfo::empty));
    }

    private <V> ListenableFuture<V> doCommit(Supplier<V> futureValueSupplier) {
        ListenableFuture<V> ret;
        AbstractDOMForwardedTransactionFactory impl = IMPL_UPDATER.getAndSet(this, null);
        this.checkRunning(impl);
        Collection txns = this.getSubtransactions();
        ArrayList<DOMStoreThreePhaseCommitCohort> cohorts = new ArrayList<DOMStoreThreePhaseCommitCohort>(txns.size());
        try {
            for (DOMStoreWriteTransaction txn : txns) {
                cohorts.add(txn.ready());
            }
            ret = impl.commit(this, cohorts, futureValueSupplier);
        }
        catch (RuntimeException e) {
            ret = FluentFuture.from((ListenableFuture)Futures.immediateFailedFuture((Throwable)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER.apply(e)));
        }
        FUTURE_UPDATER.lazySet(this, (Future)ret);
        return ret;
    }

    private void checkRunning(AbstractDOMForwardedTransactionFactory<?> impl) {
        Preconditions.checkState((impl != null ? 1 : 0) != 0, (String)"Transaction %s is no longer running", (Object)this.getIdentifier());
    }
}

