/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMForwardedTransactionFactory;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMDataBrokerTransactionChainImpl;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMDataBroker
extends AbstractDOMForwardedTransactionFactory<DOMStore>
implements DOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMDataBroker.class);
    private final AtomicLong txNum = new AtomicLong();
    private final AtomicLong chainNum = new AtomicLong();
    private final Map<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> extensions;
    private volatile AutoCloseable closeable;

    protected AbstractDOMDataBroker(Map<LogicalDatastoreType, DOMStore> datastores) {
        super(datastores);
        boolean treeChange = true;
        for (DOMStore ds : datastores.values()) {
            if (ds instanceof DOMStoreTreeChangePublisher) continue;
            treeChange = false;
            break;
        }
        this.extensions = treeChange ? ImmutableMap.of(DOMDataTreeChangeService.class, (Object)new DOMDataTreeChangeService(){

            public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerDataTreeChangeListener(DOMDataTreeIdentifier treeId, L listener) {
                DOMStore publisher = (DOMStore)AbstractDOMDataBroker.this.getTxFactories().get(treeId.getDatastoreType());
                Preconditions.checkState((publisher != null ? 1 : 0) != 0, (Object)"Requested logical data store is not available.");
                return ((DOMStoreTreeChangePublisher)publisher).registerTreeChangeListener(treeId.getRootIdentifier(), listener);
            }
        }) : Collections.emptyMap();
    }

    public void setCloseable(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    @Override
    public void close() {
        super.close();
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.debug("Error closing instance", (Throwable)e);
            }
        }
    }

    @Override
    protected Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }

    public Map<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> getSupportedExtensions() {
        return this.extensions;
    }

    public DOMTransactionChain createTransactionChain(TransactionChainListener listener) {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreTransactionChain> backingChains = new EnumMap<LogicalDatastoreType, DOMStoreTransactionChain>(LogicalDatastoreType.class);
        for (Map.Entry entry : this.getTxFactories().entrySet()) {
            backingChains.put(entry.getKey(), ((DOMStore)entry.getValue()).createTransactionChain());
        }
        long chainId = this.chainNum.getAndIncrement();
        LOG.debug("Transactoin chain {} created with listener {}, backing store chains {}", new Object[]{chainId, listener, backingChains});
        return new DOMDataBrokerTransactionChainImpl(chainId, backingChains, this, listener);
    }
}

