/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.util.OptionalBoolean;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ConfigStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.AugmentToChoiceNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundlesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;

final class SubstatementContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementContextBase<A, D, E> {
    private final StatementContextBase<?, ?, ?> parent;
    private final A argument;
    private byte configuration;
    private byte ignoreConfig;
    private byte ignoreIfFeature;
    private volatile SchemaPath schemaPath;

    SubstatementContext(StatementContextBase<?, ?, ?> parent, StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument) {
        super(def, ref, rawArgument);
        this.parent = Objects.requireNonNull(parent, "Parent must not be null");
        this.argument = def.parseArgumentValue((StmtContext<A, D, E>)this, this.rawStatementArgument());
    }

    SubstatementContext(StatementContextBase<A, D, E> original, StatementContextBase<?, ?, ?> parent, CopyType copyType, QNameModule targetModule) {
        super(original, copyType);
        this.parent = Objects.requireNonNull(parent);
        this.argument = targetModule == null ? original.getStatementArgument() : original.definition().adaptArgumentValue((StmtContext<A, D, E>)original, targetModule);
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return this.parent;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL;
    }

    @Override
    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return this.parent;
    }

    @Override
    public NamespaceBehaviour.Registry getBehaviourRegistry() {
        return this.parent.getBehaviourRegistry();
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this.parent.getRoot();
    }

    public A getStatementArgument() {
        return this.argument;
    }

    private boolean isSupportedAsShorthandCase() {
        Collection supportedCaseShorthands = (Collection)this.getFromNamespace(ValidationBundlesNamespace.class, ValidationBundlesNamespace.ValidationBundleType.SUPPORTED_CASE_SHORTHANDS);
        return supportedCaseShorthands == null || supportedCaseShorthands.contains(this.getPublicDefinition());
    }

    private SchemaPath createSchemaPath() {
        Optional maybeParentPath = this.parent.getSchemaPath();
        Verify.verify((boolean)maybeParentPath.isPresent(), (String)"Parent %s does not have a SchemaPath", this.parent);
        SchemaPath parentPath = (SchemaPath)maybeParentPath.get();
        if (StmtContextUtils.isUnknownStatement((StmtContext)this)) {
            return parentPath.createChild(this.getPublicDefinition().getStatementName());
        }
        if (this.argument instanceof QName) {
            QName qname = (QName)this.argument;
            if (StmtContextUtils.producesDeclared((StmtContext)this, UsesStatement.class)) {
                return maybeParentPath.orElse(null);
            }
            SchemaPath path = (StmtContextUtils.producesDeclared(this.parent, ChoiceStatement.class) || Boolean.TRUE.equals(this.parent.getFromNamespace(AugmentToChoiceNamespace.class, this.parent))) && this.isSupportedAsShorthandCase() ? parentPath.createChild(qname) : parentPath;
            return path.createChild(qname);
        }
        if (this.argument instanceof String) {
            Optional<StmtContext<?, ?, ?>> originalCtx = this.getOriginalCtx();
            QName qname = StmtContextUtils.qnameFromArgument((StmtContext)((StmtContext)originalCtx.orElse((StmtContext<?, ?, ?>)this)), (String)((String)this.argument));
            return parentPath.createChild(qname);
        }
        if (this.argument instanceof SchemaNodeIdentifier && (StmtContextUtils.producesDeclared((StmtContext)this, AugmentStatement.class) || StmtContextUtils.producesDeclared((StmtContext)this, RefineStatement.class) || StmtContextUtils.producesDeclared((StmtContext)this, DeviationStatement.class))) {
            return parentPath.createChild(((SchemaNodeIdentifier)this.argument).getPathFromRoot());
        }
        return maybeParentPath.orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SchemaPath> getSchemaPath() {
        SchemaPath local = this.schemaPath;
        if (local == null) {
            SubstatementContext substatementContext = this;
            synchronized (substatementContext) {
                local = this.schemaPath;
                if (local == null) {
                    this.schemaPath = local = this.createSchemaPath();
                }
            }
        }
        return Optional.ofNullable(local);
    }

    public boolean isConfiguration() {
        boolean isConfig;
        if (this.isIgnoringConfig()) {
            return true;
        }
        if (OptionalBoolean.isPresent((byte)this.configuration)) {
            return OptionalBoolean.get((byte)this.configuration);
        }
        StmtContext configStatement = StmtContextUtils.findFirstSubstatement((StmtContext)this, ConfigStatement.class);
        boolean parentIsConfig = this.parent.isConfiguration();
        if (configStatement != null) {
            isConfig = (Boolean)configStatement.coerceStatementArgument();
            InferenceException.throwIf((isConfig && !parentIsConfig ? 1 : 0) != 0, (StatementSourceReference)this.getStatementSourceReference(), (String)"Parent node has config=false, this node must not be specifed as config=true", (Object[])new Object[0]);
        } else {
            isConfig = parentIsConfig;
        }
        this.configuration = OptionalBoolean.of((boolean)isConfig);
        return isConfig;
    }

    public boolean isEnabledSemanticVersioning() {
        return this.parent.isEnabledSemanticVersioning();
    }

    public YangVersion getRootVersion() {
        return this.getRoot().getRootVersion();
    }

    public void setRootVersion(YangVersion version) {
        this.getRoot().setRootVersion(version);
    }

    public void addMutableStmtToSeal(MutableStatement mutableStatement) {
        this.getRoot().addMutableStmtToSeal(mutableStatement);
    }

    public void addRequiredSource(SourceIdentifier dependency) {
        this.getRoot().addRequiredSource(dependency);
    }

    public void setRootIdentifier(SourceIdentifier identifier) {
        this.getRoot().setRootIdentifier(identifier);
    }

    @Override
    protected boolean isIgnoringIfFeatures() {
        if (OptionalBoolean.isPresent((byte)this.ignoreIfFeature)) {
            return OptionalBoolean.get((byte)this.ignoreIfFeature);
        }
        boolean ret = this.definition().isIgnoringIfFeatures() || this.parent.isIgnoringIfFeatures();
        this.ignoreIfFeature = OptionalBoolean.of((boolean)ret);
        return ret;
    }

    @Override
    protected boolean isIgnoringConfig() {
        if (OptionalBoolean.isPresent((byte)this.ignoreConfig)) {
            return OptionalBoolean.get((byte)this.ignoreConfig);
        }
        boolean ret = this.definition().isIgnoringConfig() || this.parent.isIgnoringConfig();
        this.ignoreConfig = OptionalBoolean.of((boolean)ret);
        return ret;
    }

    @Override
    protected boolean isParentSupportedByFeatures() {
        return this.parent.isSupportedByFeatures();
    }
}

