/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

abstract class StatementMap {
    private static final StatementMap EMPTY = new Empty();

    StatementMap() {
    }

    static StatementMap empty() {
        return EMPTY;
    }

    abstract @Nullable StatementContextBase<?, ?, ?> get(int var1);

    abstract @NonNull StatementMap put(int var1, @NonNull StatementContextBase<?, ?, ?> var2);

    abstract @NonNull Collection<StatementContextBase<?, ?, ?>> values();

    abstract int size();

    abstract @NonNull StatementMap ensureCapacity(int var1);

    abstract int capacity();

    public final String toString() {
        return MoreObjects.toStringHelper(StatementMap.class).add("values", this.values()).toString();
    }

    private static final class Singleton
    extends StatementMap {
        private final StatementContextBase<?, ?, ?> object;

        Singleton(StatementContextBase<?, ?, ?> object) {
            this.object = Objects.requireNonNull(object);
        }

        @Override
        StatementContextBase<?, ?, ?> get(int index) {
            return index == 0 ? this.object : null;
        }

        @Override
        StatementMap put(int index, StatementContextBase<?, ?, ?> obj) {
            Preconditions.checkArgument((index != 0 ? 1 : 0) != 0);
            return new Regular(this.object, index, obj);
        }

        @Override
        Collection<StatementContextBase<?, ?, ?>> values() {
            return ImmutableList.of(this.object);
        }

        @Override
        int size() {
            return 1;
        }

        @Override
        StatementMap ensureCapacity(int expectedLimit) {
            return expectedLimit < 2 ? this : new Regular(expectedLimit, 0, this.object);
        }

        @Override
        int capacity() {
            return 1;
        }
    }

    private static final class RegularAsCollection<T>
    extends AbstractCollection<T> {
        private final T[] elements;
        private final int size;

        RegularAsCollection(T[] elements, int size) {
            this.elements = Objects.requireNonNull(elements);
            this.size = size;
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (T e : this.elements) {
                if (e == null) continue;
                action.accept(e);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                private int nextOffset = 0;

                protected T computeNext() {
                    while (this.nextOffset < elements.length) {
                        Object ret = elements[this.nextOffset++];
                        if (ret == null) continue;
                        return ret;
                    }
                    return this.endOfData();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static final class Regular
    extends StatementMap {
        private StatementContextBase<?, ?, ?>[] elements;
        private int size;

        Regular(int expectedLimit) {
            this.elements = new StatementContextBase[expectedLimit];
        }

        Regular(int index, StatementContextBase<?, ?, ?> object) {
            this(index + 1, index, object);
        }

        Regular(StatementContextBase<?, ?, ?> object0, int index, StatementContextBase<?, ?, ?> object) {
            this(index + 1, 0, object0);
            this.elements[index] = Objects.requireNonNull(object);
            this.size = 2;
        }

        Regular(int expectedLimit, int index, StatementContextBase<?, ?, ?> object) {
            this(expectedLimit);
            this.elements[index] = Objects.requireNonNull(object);
            this.size = 1;
        }

        @Override
        StatementContextBase<?, ?, ?> get(int index) {
            return index >= this.elements.length ? null : this.elements[index];
        }

        @Override
        StatementMap put(int index, StatementContextBase<?, ?, ?> obj) {
            if (index < this.elements.length) {
                Preconditions.checkArgument((this.elements[index] == null ? 1 : 0) != 0);
            } else {
                this.elements = Arrays.copyOf(this.elements, index + 1);
            }
            this.elements[index] = Objects.requireNonNull(obj);
            ++this.size;
            return this;
        }

        @Override
        Collection<StatementContextBase<?, ?, ?>> values() {
            return new RegularAsCollection(this.elements, this.size);
        }

        @Override
        int size() {
            return this.size;
        }

        @Override
        StatementMap ensureCapacity(int expectedLimit) {
            if (this.elements.length < expectedLimit) {
                this.elements = Arrays.copyOf(this.elements, expectedLimit);
            }
            return this;
        }

        @Override
        int capacity() {
            return this.elements.length;
        }
    }

    private static final class Empty
    extends StatementMap {
        private Empty() {
        }

        @Override
        StatementContextBase<?, ?, ?> get(int index) {
            return null;
        }

        @Override
        StatementMap put(int index, StatementContextBase<?, ?, ?> obj) {
            return index == 0 ? new Singleton(obj) : new Regular(index, obj);
        }

        @Override
        Collection<StatementContextBase<?, ?, ?>> values() {
            return ImmutableList.of();
        }

        @Override
        int size() {
            return 0;
        }

        @Override
        StatementMap ensureCapacity(int expectedLimit) {
            return expectedLimit < 2 ? this : new Regular(expectedLimit);
        }

        @Override
        int capacity() {
            return 0;
        }
    }
}

