/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public class StatementDefinitionContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> {
    private final @NonNull StatementSupport<A, D, E> support;
    private final Map<String, StatementDefinitionContext<?, ?, ?>> argumentSpecificSubDefinitions;
    private Map<StatementDefinitionContext<?, ?, ?>, StatementDefinitionContext<?, ?, ?>> unknownStmtDefsOfYangStmts;

    public StatementDefinitionContext(StatementSupport<A, D, E> support) {
        this.support = Objects.requireNonNull(support);
        this.argumentSpecificSubDefinitions = support.hasArgumentSpecificSupports() ? new HashMap() : null;
    }

    public @NonNull StatementFactory<A, D, E> getFactory() {
        return this.support;
    }

    public A parseArgumentValue(StmtContext<A, D, E> context, String value) {
        return (A)this.support.parseArgumentValue(context, value);
    }

    public A adaptArgumentValue(StmtContext<A, D, E> context, QNameModule targetModule) {
        return (A)this.support.adaptArgumentValue(context, targetModule);
    }

    public void checkNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> namespace) {
    }

    public @NonNull StatementDefinition getPublicView() {
        return this.support.getPublicView();
    }

    public Optional<StatementSupport<?, ?, ?>> getImplicitParentFor(StatementDefinition stmtDef) {
        return this.support.getImplicitParentFor(stmtDef);
    }

    public boolean onStatementAdded(StmtContext.Mutable<A, D, E> stmt) {
        this.support.onStatementAdded(stmt);
        return false;
    }

    public void onDeclarationFinished(StmtContext.Mutable<A, D, E> statement, ModelProcessingPhase phase) {
        switch (phase) {
            case SOURCE_PRE_LINKAGE: {
                this.support.onPreLinkageDeclared(statement);
                break;
            }
            case SOURCE_LINKAGE: {
                this.support.onLinkageDeclared(statement);
                break;
            }
            case STATEMENT_DEFINITION: {
                this.support.onStatementDefinitionDeclared(statement);
                break;
            }
            case FULL_DECLARATION: {
                this.support.onFullDefinitionDeclared(statement);
                break;
            }
        }
    }

    public @NonNull Class<?> getRepresentingClass() {
        return this.support.getDeclaredRepresentationClass();
    }

    public boolean hasArgument() {
        return this.support.getArgumentName() != null;
    }

    public boolean isArgumentYinElement() {
        return this.support.isArgumentYinElement();
    }

    public @NonNull QName getStatementName() {
        return this.support.getStatementName();
    }

    public QName getArgumentName() {
        return this.support.getArgumentName();
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("statement", (Object)this.getStatementName());
    }

    @NonNull StatementDefinitionContext<?, ?, ?> getSubDefinitionSpecificForArgument(String argument) {
        if (!this.hasArgumentSpecificSubDefinitions()) {
            return this;
        }
        StatementDefinitionContext<A, D, E> potential = this.argumentSpecificSubDefinitions.get(argument);
        if (potential == null) {
            StatementSupport argumentSpecificSupport = this.support.getSupportSpecificForArgument(argument);
            potential = argumentSpecificSupport != null ? new StatementDefinitionContext<A, D, E>(argumentSpecificSupport) : this;
            this.argumentSpecificSubDefinitions.put(argument, potential);
        }
        return potential;
    }

    boolean hasArgumentSpecificSubDefinitions() {
        return this.support.hasArgumentSpecificSupports();
    }

    String internArgument(String rawArgument) {
        return this.support.internArgument(rawArgument);
    }

    StatementDefinitionContext<?, ?, ?> getAsUnknownStatementDefinition(StatementDefinitionContext<?, ?, ?> yangStmtDef) {
        StatementDefinitionContext ret;
        if (this.unknownStmtDefsOfYangStmts != null) {
            StatementDefinitionContext<?, ?, ?> existing = this.unknownStmtDefsOfYangStmts.get(yangStmtDef);
            if (existing != null) {
                return existing;
            }
        } else {
            this.unknownStmtDefsOfYangStmts = new HashMap();
        }
        if ((ret = (StatementDefinitionContext)this.support.getUnknownStatementDefinitionOf(yangStmtDef.getPublicView()).map(StatementDefinitionContext::new).orElse(null)) != null) {
            this.unknownStmtDefsOfYangStmts.put(yangStmtDef, ret);
        }
        return ret;
    }

    boolean isIgnoringIfFeatures() {
        return this.support.isIgnoringIfFeatures();
    }

    boolean isIgnoringConfig() {
        return this.support.isIgnoringConfig();
    }
}

