/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SourceSpecificContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

final class StatementContextWriter
implements StatementWriter {
    private final ModelProcessingPhase phase;
    private final SourceSpecificContext ctx;
    private StatementContextBase<?, ?, ?> current;

    StatementContextWriter(SourceSpecificContext ctx, ModelProcessingPhase phase) {
        this.ctx = Objects.requireNonNull(ctx);
        this.phase = Objects.requireNonNull(phase);
    }

    public Optional<? extends StatementWriter.ResumedStatement> resumeStatement(int childId) {
        Optional<StatementContextBase<?, ?, ?>> existing = this.ctx.lookupDeclaredChild(this.current, childId);
        existing.ifPresent(this::resumeStatement);
        return existing;
    }

    private void resumeStatement(StatementContextBase<?, ?, ?> child) {
        if (child.isFullyDefined()) {
            child.walkChildren(this.phase);
            child.endDeclared(this.phase);
        } else {
            this.current = child;
        }
    }

    public void storeStatement(int expectedChildren, boolean fullyDefined) {
        Preconditions.checkState((this.current != null ? 1 : 0) != 0);
        Preconditions.checkArgument((expectedChildren >= 0 ? 1 : 0) != 0);
        this.current.resizeSubstatements(expectedChildren);
        if (fullyDefined) {
            this.current.setFullyDefined();
        }
    }

    public void startStatement(int childId, QName name, String argument, StatementSourceReference ref) {
        Optional<StatementContextBase<?, ?, ?>> existing = this.ctx.lookupDeclaredChild(this.current, childId);
        this.current = existing.isPresent() ? existing.get() : (StatementContextBase)Verify.verifyNotNull(this.ctx.createDeclaredChild(this.current, childId, name, argument, ref));
    }

    public void endStatement(StatementSourceReference ref) {
        Preconditions.checkState((this.current != null ? 1 : 0) != 0);
        this.current.endDeclared(this.phase);
        this.exitStatement();
    }

    public ModelProcessingPhase getPhase() {
        return this.phase;
    }

    private void exitStatement() {
        StmtContext.Mutable parentContext;
        for (parentContext = this.current.getParentContext(); parentContext != null && StatementSource.CONTEXT == parentContext.getStatementSource(); parentContext = parentContext.getParentContext()) {
            parentContext.endDeclared(this.phase);
        }
        this.current = parentContext;
    }
}

