/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementDefinitionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportBundle;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportedModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModuleMap;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinitionMap;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.BuildGlobalContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ModifierImpl;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceSpecificContext
implements NamespaceBehaviour.NamespaceStorageNode,
NamespaceBehaviour.Registry,
Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(SourceSpecificContext.class);
    private final Multimap<ModelProcessingPhase, ModifierImpl> modifiers = HashMultimap.create();
    private final QNameToStatementDefinitionMap qnameToStmtDefMap = new QNameToStatementDefinitionMap();
    private final PrefixToModuleMap prefixToModuleMap = new PrefixToModuleMap();
    private final BuildGlobalContext currentContext;
    private final StatementStreamSource source;
    private Collection<RootStatementContext<?, ?, ?>> importedNamespaces = ImmutableList.of();
    private ModelProcessingPhase finishedPhase = ModelProcessingPhase.INIT;
    private ModelProcessingPhase inProgressPhase;
    private RootStatementContext<?, ?, ?> root;

    SourceSpecificContext(BuildGlobalContext currentContext, StatementStreamSource source) {
        this.currentContext = Objects.requireNonNull(currentContext);
        this.source = Objects.requireNonNull(source);
    }

    boolean isEnabledSemanticVersioning() {
        return this.currentContext.isEnabledSemanticVersioning();
    }

    ModelProcessingPhase getInProgressPhase() {
        return this.inProgressPhase;
    }

    Optional<StatementContextBase<?, ?, ?>> lookupDeclaredChild(StatementContextBase<?, ?, ?> current, int childId) {
        StatementContextBase<?, ?, ?> existing;
        if (current == null) {
            return Optional.empty();
        }
        for (existing = current.lookupSubstatement(childId); existing != null && StatementSource.CONTEXT == existing.getStatementSource(); existing = existing.lookupSubstatement(childId)) {
        }
        return Optional.ofNullable(existing);
    }

    StatementContextBase<?, ?, ?> createDeclaredChild(StatementContextBase<?, ?, ?> current, int childId, QName name, String argument, StatementSourceReference ref) {
        StatementDefinitionContext<Object, Object, Object> def = this.currentContext.getStatementDefinition(this.getRootVersion(), name);
        if (def == null) {
            StatementSupport extension;
            def = this.currentContext.getModelDefinedStatementDefinition(name);
            if (def == null && (extension = this.qnameToStmtDefMap.get(name)) != null) {
                def = new StatementDefinitionContext(extension);
                this.currentContext.putModelDefinedStatementDefinition(name, def);
            }
        } else if (current != null && StmtContextUtils.isUnrecognizedStatement(current)) {
            def = (StatementDefinitionContext)Preconditions.checkNotNull(current.definition().getAsUnknownStatementDefinition(def), (String)"Unable to create unknown statement definition of yang statement %s in unknown statement %s", def, current);
        }
        if (((StatementDefinitionContext)InferenceException.throwIfNull(def, (StatementSourceReference)ref, (String)"Statement %s does not have type mapping defined.", (Object[])new Object[]{name})).hasArgument()) {
            SourceException.throwIfNull((Object)argument, (StatementSourceReference)ref, (String)"Statement %s requires an argument", (Object[])new Object[]{name});
        } else {
            SourceException.throwIf((argument != null ? 1 : 0) != 0, (StatementSourceReference)ref, (String)"Statement %s does not take argument", (Object[])new Object[]{name});
        }
        if (def.hasArgumentSpecificSubDefinitions()) {
            def = def.getSubDefinitionSpecificForArgument(argument);
        }
        if (current != null) {
            return current.createSubstatement(childId, def, ref, argument);
        }
        if (this.root == null) {
            this.root = new RootStatementContext(this, def, ref, argument);
        } else if (!RootStatementContext.DEFAULT_VERSION.equals((Object)this.root.getRootVersion()) && this.inProgressPhase == ModelProcessingPhase.SOURCE_LINKAGE) {
            this.root = new RootStatementContext<Object, Object, Object>(this, def, ref, argument, this.root.getRootVersion(), this.root.getRootIdentifier());
        } else {
            QName rootStatement = this.root.definition().getStatementName();
            String rootArgument = this.root.rawStatementArgument();
            Preconditions.checkState((Objects.equals(def.getStatementName(), rootStatement) && Objects.equals(argument, rootArgument) ? 1 : 0) != 0, (String)"Root statement was already defined as '%s %s'.", (Object)rootStatement, (Object)rootArgument);
        }
        return this.root;
    }

    RootStatementContext<?, ?, ?> getRoot() {
        return this.root;
    }

    YangVersion getRootVersion() {
        return this.root != null ? this.root.getRootVersion() : RootStatementContext.DEFAULT_VERSION;
    }

    DeclaredStatement<?> buildDeclared() {
        return this.root.buildDeclared();
    }

    EffectiveStatement<?, ?> buildEffective() {
        return this.root.buildEffective();
    }

    void startPhase(ModelProcessingPhase phase) {
        ModelProcessingPhase previousPhase = phase.getPreviousPhase();
        Verify.verify((boolean)Objects.equals(previousPhase, this.finishedPhase), (String)"Phase sequencing violation: previous phase should be %s, source %s has %s", (Object)previousPhase, (Object)this.source, (Object)this.finishedPhase);
        Collection previousModifiers = this.modifiers.get((Object)previousPhase);
        Preconditions.checkState((boolean)previousModifiers.isEmpty(), (String)"Previous phase %s has unresolved modifiers %s in source %s", (Object)previousPhase, (Object)previousModifiers, (Object)this.source);
        this.inProgressPhase = phase;
        LOG.debug("Source {} started phase {}", (Object)this.source, (Object)phase);
    }

    private void updateImportedNamespaces(Class<?> type, Object value) {
        if (BelongsToModuleContext.class.isAssignableFrom(type) || ImportedModuleContext.class.isAssignableFrom(type)) {
            if (this.importedNamespaces.isEmpty()) {
                this.importedNamespaces = new ArrayList(1);
            }
            Verify.verify((boolean)(value instanceof RootStatementContext));
            this.importedNamespaces.add((RootStatementContext)value);
        }
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V putToLocalStorage(Class<N> type, K key, V value) {
        V ret = this.getRoot().putToLocalStorage(type, key, value);
        this.updateImportedNamespaces(type, value);
        return ret;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V putToLocalStorageIfAbsent(Class<N> type, K key, V value) {
        Object ret = this.getRoot().putToLocalStorageIfAbsent((Class)type, (Object)key, (Object)value);
        if (ret == null) {
            this.updateImportedNamespaces(type, value);
        }
        return (V)ret;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.SOURCE_LOCAL_SPECIAL;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        Object potentialLocal = this.getRoot().getFromLocalStorage(type, key);
        if (potentialLocal != null) {
            return potentialLocal;
        }
        for (NamespaceBehaviour.NamespaceStorageNode namespaceStorageNode : this.importedNamespaces) {
            Object potential = namespaceStorageNode.getFromLocalStorage(type, key);
            if (potential == null) continue;
            return (V)potential;
        }
        return null;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromLocalStorage(Class<N> type) {
        Map potentialLocal = this.getRoot().getAllFromLocalStorage(type);
        if (potentialLocal != null) {
            return potentialLocal;
        }
        for (NamespaceBehaviour.NamespaceStorageNode namespaceStorageNode : this.importedNamespaces) {
            Map potential = namespaceStorageNode.getAllFromLocalStorage(type);
            if (potential == null) continue;
            return potential;
        }
        return null;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> getNamespaceBehaviour(Class<N> type) {
        return this.currentContext.getNamespaceBehaviour((Class)type);
    }

    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return this.currentContext;
    }

    PhaseCompletionProgress tryToCompletePhase(ModelProcessingPhase phase) {
        Collection currentPhaseModifiers = this.modifiers.get((Object)phase);
        boolean hasProgressed = SourceSpecificContext.tryToProgress(currentPhaseModifiers);
        Preconditions.checkNotNull(this.root, (Object)"Malformed source. Valid root element is missing.");
        boolean phaseCompleted = this.root.tryToCompletePhase(phase);
        hasProgressed |= SourceSpecificContext.tryToProgress(currentPhaseModifiers);
        if (phaseCompleted && currentPhaseModifiers.isEmpty()) {
            this.finishedPhase = phase;
            LOG.debug("Source {} finished phase {}", (Object)this.source, (Object)phase);
            return PhaseCompletionProgress.FINISHED;
        }
        return hasProgressed ? PhaseCompletionProgress.PROGRESS : PhaseCompletionProgress.NO_PROGRESS;
    }

    private static boolean tryToProgress(Collection<ModifierImpl> currentPhaseModifiers) {
        boolean hasProgressed = false;
        Iterator<ModifierImpl> modifier = currentPhaseModifiers.iterator();
        while (modifier.hasNext()) {
            if (!modifier.next().tryApply()) continue;
            modifier.remove();
            hasProgressed = true;
        }
        return hasProgressed;
    }

    @NonNull ModelActionBuilder newInferenceAction(@NonNull ModelProcessingPhase phase) {
        ModifierImpl action = new ModifierImpl();
        this.modifiers.put((Object)phase, (Object)action);
        return action;
    }

    public String toString() {
        return "SourceSpecificContext [source=" + this.source + ", current=" + this.inProgressPhase + ", finished=" + this.finishedPhase + "]";
    }

    Optional<SourceException> failModifiers(ModelProcessingPhase identifier) {
        ArrayList<SourceException> exceptions = new ArrayList<SourceException>();
        for (ModifierImpl mod : this.modifiers.get((Object)identifier)) {
            try {
                mod.failModifier();
            }
            catch (SourceException e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return Optional.empty();
        }
        String message = String.format("Yang model processing phase %s failed", identifier);
        InferenceException e = new InferenceException(message, this.root.getStatementSourceReference(), (Throwable)exceptions.get(0));
        exceptions.listIterator(1).forEachRemaining(arg_0 -> e.addSuppressed(arg_0));
        return Optional.of(e);
    }

    void loadStatements() {
        LOG.trace("Source {} loading statements for phase {}", (Object)this.source, (Object)this.inProgressPhase);
        switch (this.inProgressPhase) {
            case SOURCE_PRE_LINKAGE: {
                this.source.writePreLinkage((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef());
                break;
            }
            case SOURCE_LINKAGE: {
                this.source.writeLinkage((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.preLinkagePrefixes(), this.getRootVersion());
                break;
            }
            case STATEMENT_DEFINITION: {
                this.source.writeLinkageAndStatementDefinitions((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.prefixes(), this.getRootVersion());
                break;
            }
            case FULL_DECLARATION: {
                this.source.writeFull((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.prefixes(), this.getRootVersion());
                break;
            }
        }
    }

    private PrefixToModule preLinkagePrefixes() {
        PrefixToModuleMap preLinkagePrefixes = new PrefixToModuleMap(true);
        Map<String, URI> prefixToNamespaceMap = this.getAllFromLocalStorage(ImpPrefixToNamespace.class);
        if (prefixToNamespaceMap == null) {
            return null;
        }
        prefixToNamespaceMap.forEach((key, value) -> preLinkagePrefixes.put(key, QNameModule.create((URI)value)));
        return preLinkagePrefixes;
    }

    private PrefixToModule prefixes() {
        Map<String, StmtContext> allBelongsTo;
        Map<String, StmtContext> allImports = this.getRoot().getAllFromNamespace(ImportPrefixToModuleCtx.class);
        if (allImports != null) {
            allImports.forEach((key, value) -> this.prefixToModuleMap.put(key, (QNameModule)this.getRoot().getFromNamespace(ModuleCtxToModuleQName.class, value)));
        }
        if ((allBelongsTo = this.getRoot().getAllFromNamespace(BelongsToPrefixToModuleCtx.class)) != null) {
            allBelongsTo.forEach((key, value) -> this.prefixToModuleMap.put(key, (QNameModule)this.getRoot().getFromNamespace(ModuleCtxToModuleQName.class, value)));
        }
        return this.prefixToModuleMap;
    }

    private QNameToStatementDefinition stmtDef() {
        StatementSupportBundle supportsForPhase = this.currentContext.getSupportsForPhase(this.inProgressPhase);
        this.qnameToStmtDefMap.putAll((Map)supportsForPhase.getCommonDefinitions());
        this.qnameToStmtDefMap.putAll((Map)supportsForPhase.getDefinitionsSpecificForVersion(this.getRootVersion()));
        if (this.inProgressPhase != ModelProcessingPhase.FULL_DECLARATION) {
            return this.qnameToStmtDefMap;
        }
        Map<QName, StatementSupport> extensions = this.currentContext.getAllFromNamespace(StatementDefinitionNamespace.class);
        if (extensions != null) {
            extensions.forEach((qname, support) -> {
                StatementSupport existing = this.qnameToStmtDefMap.putIfAbsent(qname, support);
                if (existing != null) {
                    LOG.debug("Source {} already defines statement {} as {}", new Object[]{this.source, qname, existing});
                } else {
                    LOG.debug("Source {} defined statement {} as {}", new Object[]{this.source, qname, support});
                }
            });
        }
        return this.qnameToStmtDefMap;
    }

    public Set<YangVersion> getSupportedVersions() {
        return this.currentContext.getSupportedVersions();
    }

    void addMutableStmtToSeal(MutableStatement mutableStatement) {
        this.currentContext.addMutableStmtToSeal(mutableStatement);
    }

    Collection<SourceIdentifier> getRequiredSources() {
        return this.root.getRequiredSources();
    }

    SourceIdentifier getRootIdentifier() {
        return this.root.getRootIdentifier();
    }

    public static enum PhaseCompletionProgress {
        NO_PROGRESS,
        PROGRESS,
        FINISHED;

    }
}

