/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

abstract class NamespaceStorageSupport
implements NamespaceBehaviour.NamespaceStorageNode {
    private Map<Class<?>, Map<?, ?>> namespaces = ImmutableMap.of();

    NamespaceStorageSupport() {
    }

    public abstract NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage();

    public abstract NamespaceBehaviour.Registry getBehaviourRegistry();

    protected void checkLocalNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> type) {
    }

    protected <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceElementAdded(Class<N> type, K key, V value) {
    }

    public final <K, V, T extends K, N extends IdentifierNamespace<K, V>> V getFromNamespace(Class<N> type, T key) {
        return (V)this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom((NamespaceBehaviour.NamespaceStorageNode)this, key);
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Optional<Map.Entry<K, V>> getFromNamespace(Class<N> type, NamespaceKeyCriterion<K> criterion) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom((NamespaceBehaviour.NamespaceStorageNode)this, criterion);
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromNamespace(Class<N> type) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getAllFrom((NamespaceBehaviour.NamespaceStorageNode)this);
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromCurrentStmtCtxNamespace(Class<N> type) {
        return this.namespaces.get(type);
    }

    public final <K, V, T extends K, U extends V, N extends IdentifierNamespace<K, V>> void addToNs(Class<N> type, T key, U value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    public final <K, N extends StatementNamespace<K, ?, ?>> void addContextToNamespace(Class<N> type, K key, StmtContext<?, ?, ?> value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        Map<?, ?> localNamespace = this.namespaces.get(type);
        return localNamespace == null ? null : (V)localNamespace.get(key);
    }

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromLocalStorage(Class<N> type) {
        Map<?, ?> localNamespace = this.namespaces.get(type);
        return localNamespace;
    }

    private <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> ensureLocalNamespace(Class<N> type) {
        Map<?, ?> ret = this.namespaces.get(type);
        if (ret == null) {
            this.checkLocalNamespaceAllowed(type);
            ret = new HashMap(1);
            if (this.namespaces.isEmpty()) {
                this.namespaces = new HashMap(1);
            }
            this.namespaces.put(type, ret);
        }
        return ret;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V putToLocalStorage(Class<N> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).put(key, value);
        this.onNamespaceElementAdded(type, key, value);
        return ret;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V putToLocalStorageIfAbsent(Class<N> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).putIfAbsent(key, value);
        if (ret == null) {
            this.onNamespaceElementAdded(type, key, value);
        }
        return ret;
    }
}

