/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.Address;
import akka.actor.Props;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.remote.rpc.RemoteRpcImplementation;
import org.opendaylight.controller.remote.rpc.RemoteRpcProviderConfig;
import org.opendaylight.controller.remote.rpc.registry.RpcRegistry;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;

final class RpcRegistrar
extends AbstractUntypedActor {
    private final Map<Address, DOMRpcImplementationRegistration<?>> regs = new HashMap();
    private final DOMRpcProviderService rpcProviderService;
    private final RemoteRpcProviderConfig config;

    RpcRegistrar(RemoteRpcProviderConfig config, DOMRpcProviderService rpcProviderService) {
        this.config = (RemoteRpcProviderConfig)((Object)Preconditions.checkNotNull((Object)((Object)config)));
        this.rpcProviderService = (DOMRpcProviderService)Preconditions.checkNotNull((Object)rpcProviderService);
    }

    public static Props props(RemoteRpcProviderConfig config, DOMRpcProviderService rpcProviderService) {
        Preconditions.checkNotNull((Object)rpcProviderService, (Object)"DOMRpcProviderService cannot be null");
        return Props.create(RpcRegistrar.class, (Object[])new Object[]{config, rpcProviderService});
    }

    public void postStop() throws Exception {
        this.regs.values().forEach(DOMRpcImplementationRegistration::close);
        this.regs.clear();
        super.postStop();
    }

    protected void handleReceive(Object message) {
        if (message instanceof RpcRegistry.Messages.UpdateRemoteEndpoints) {
            this.updateRemoteEndpoints(((RpcRegistry.Messages.UpdateRemoteEndpoints)message).getEndpoints());
        } else {
            this.unknownMessage(message);
        }
    }

    private void updateRemoteEndpoints(Map<Address, Optional<RpcRegistry.RemoteRpcEndpoint>> endpoints) {
        ArrayList<DOMRpcImplementationRegistration> prevRegs = new ArrayList<DOMRpcImplementationRegistration>(endpoints.size());
        for (Map.Entry<Address, Optional<RpcRegistry.RemoteRpcEndpoint>> e : endpoints.entrySet()) {
            DOMRpcImplementationRegistration prevReg;
            this.LOG.debug("Updating RPC registrations for {}", (Object)e.getKey());
            Optional<RpcRegistry.RemoteRpcEndpoint> maybeEndpoint = e.getValue();
            if (maybeEndpoint.isPresent()) {
                RpcRegistry.RemoteRpcEndpoint endpoint = maybeEndpoint.get();
                RemoteRpcImplementation impl = new RemoteRpcImplementation(endpoint.getRouter(), this.config);
                prevReg = this.regs.put(e.getKey(), this.rpcProviderService.registerRpcImplementation((DOMRpcImplementation)impl, endpoint.getRpcs()));
            } else {
                prevReg = this.regs.remove(e.getKey());
            }
            if (prevReg == null) continue;
            prevRegs.add(prevReg);
        }
        for (DOMRpcImplementationRegistration r : prevRegs) {
            r.close();
        }
    }
}

