/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.controller.remote.rpc.RemoteRpcImplementation;
import org.opendaylight.controller.remote.rpc.registry.RpcRegistry;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RpcListener
implements DOMRpcAvailabilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(RpcListener.class);
    private final ActorRef rpcRegistry;

    RpcListener(ActorRef rpcRegistry) {
        this.rpcRegistry = Objects.requireNonNull(rpcRegistry);
    }

    public void onRpcAvailable(Collection<DOMRpcIdentifier> rpcs) {
        Preconditions.checkArgument((rpcs != null ? 1 : 0) != 0, (Object)"Input Collection of DOMRpcIdentifier can not be null.");
        LOG.debug("Adding registration for [{}]", rpcs);
        this.rpcRegistry.tell((Object)new RpcRegistry.Messages.AddOrUpdateRoutes(rpcs), ActorRef.noSender());
    }

    public void onRpcUnavailable(Collection<DOMRpcIdentifier> rpcs) {
        Preconditions.checkArgument((rpcs != null ? 1 : 0) != 0, (Object)"Input Collection of DOMRpcIdentifier can not be null.");
        LOG.debug("Removing registration for [{}]", rpcs);
        this.rpcRegistry.tell((Object)new RpcRegistry.Messages.RemoveRoutes(rpcs), ActorRef.noSender());
    }

    public boolean acceptsImplementation(DOMRpcImplementation impl) {
        return !(impl instanceof RemoteRpcImplementation);
    }
}

