/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.remote.rpc.RpcErrorsException;
import org.opendaylight.controller.remote.rpc.messages.ExecuteRpc;
import org.opendaylight.controller.remote.rpc.messages.RpcResponse;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class RpcInvoker
extends AbstractUntypedActor {
    private final DOMRpcService rpcService;

    private RpcInvoker(DOMRpcService rpcService) {
        this.rpcService = (DOMRpcService)Preconditions.checkNotNull((Object)rpcService);
    }

    public static Props props(DOMRpcService rpcService) {
        Preconditions.checkNotNull((Object)rpcService, (Object)"DOMRpcService can not be null");
        return Props.create(RpcInvoker.class, (Object[])new Object[]{rpcService});
    }

    protected void handleReceive(Object message) {
        if (message instanceof ExecuteRpc) {
            this.executeRpc((ExecuteRpc)message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void executeRpc(final ExecuteRpc msg) {
        FluentFuture future;
        this.LOG.debug("Executing rpc {}", (Object)msg.getRpc());
        SchemaPath schemaPath = SchemaPath.create((boolean)true, (QName[])new QName[]{msg.getRpc()});
        final ActorRef sender = this.getSender();
        final ActorRef self = this.self();
        try {
            future = this.rpcService.invokeRpc(schemaPath, msg.getInputNormalizedNode());
        }
        catch (RuntimeException e) {
            this.LOG.debug("Failed to invoke RPC {}", (Object)msg.getRpc(), (Object)e);
            sender.tell((Object)new Status.Failure((Throwable)e), sender);
            return;
        }
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<DOMRpcResult>(){

            public void onSuccess(DOMRpcResult result) {
                if (result == null) {
                    RpcInvoker.this.LOG.debug("Got null DOMRpcResult - sending null response for execute rpc : {}", (Object)msg.getRpc());
                    sender.tell((Object)new RpcResponse(null), self);
                    return;
                }
                if (!result.getErrors().isEmpty()) {
                    String message = String.format("Execution of RPC %s failed", msg.getRpc());
                    sender.tell((Object)new Status.Failure((Throwable)((Object)new RpcErrorsException(message, result.getErrors()))), self);
                } else {
                    RpcInvoker.this.LOG.debug("Sending response for execute rpc : {}", (Object)msg.getRpc());
                    sender.tell((Object)new RpcResponse(result.getResult()), self);
                }
            }

            public void onFailure(Throwable failure) {
                RpcInvoker.this.LOG.debug("Failed to execute RPC {}", (Object)msg.getRpc(), (Object)failure);
                RpcInvoker.this.LOG.error("Failed to execute RPC {} due to {}. More details are available on DEBUG level.", (Object)msg.getRpc(), (Object)Throwables.getRootCause((Throwable)failure).getMessage());
                sender.tell((Object)new Status.Failure(failure), self);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

