/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import org.opendaylight.controller.remote.rpc.RemoteDOMRpcFuture;
import org.opendaylight.controller.remote.rpc.RemoteRpcProviderConfig;
import org.opendaylight.controller.remote.rpc.messages.ExecuteRpc;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import scala.concurrent.Future;

final class RemoteRpcImplementation
implements DOMRpcImplementation {
    private static final long COST = 2L;
    private final ActorRef remoteInvoker;
    private final Timeout askDuration;

    RemoteRpcImplementation(ActorRef remoteInvoker, RemoteRpcProviderConfig config) {
        this.remoteInvoker = (ActorRef)Preconditions.checkNotNull((Object)remoteInvoker);
        this.askDuration = config.getAskDuration();
    }

    public FluentFuture<DOMRpcResult> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
        RemoteDOMRpcFuture ret = RemoteDOMRpcFuture.create(rpc.getType().getLastComponent());
        ret.completeWith((Future<Object>)Patterns.ask((ActorRef)this.remoteInvoker, (Object)ExecuteRpc.from(rpc, input), (Timeout)this.askDuration));
        return ret;
    }

    public long invocationCost() {
        return 2L;
    }
}

