/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.model.Users;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cli.utils.CliUtils;

@Service
@Command(name="change-user-pwd", scope="aaa", description="Change the user password.")
public class ChangeUserPassword
implements Action {
    @Reference
    private IIDMStore identityStore;
    @Reference
    private ClaimCache claimCache;
    @Option(name="-user", aliases={"--userName"}, description="The user name", required=true, multiValued=false)
    private String userName;
    @Reference
    private PasswordHashService passwordService;

    public Object execute() throws Exception {
        if (this.identityStore == null) {
            return "Failed to access the users data store";
        }
        String currentPwd = CliUtils.readPassword("Enter current password:");
        String newPwd = CliUtils.readPassword("Enter new password:");
        Users users = this.identityStore.getUsers();
        for (User usr : users.getUsers()) {
            if (!usr.getName().equals(this.userName) || !this.passwordService.passwordsMatch(currentPwd, usr.getPassword(), usr.getSalt())) continue;
            this.claimCache.clear();
            usr.setPassword(newPwd);
            this.identityStore.updateUser(usr);
            return this.userName + "'s password has been changed";
        }
        return "User does not exist OR user name and passsword are not correct";
    }
}

