/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.cli.AaaCliAbstractCommand;
import org.opendaylight.aaa.cli.utils.CliUtils;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@Service
@Command(name="add-user", scope="aaa", description="Add user.")
public class AddUser
extends AaaCliAbstractCommand {
    @Option(name="-name", aliases={"--userName"}, description="The user name", required=true, multiValued=false)
    private String userName;
    @Option(name="-dname", aliases={"--domainName"}, description="The domain name", required=true, multiValued=false)
    private String domainName;
    @Option(name="-rname", aliases={"--roleName"}, description="The role name", required=false, multiValued=false)
    private String roleName;
    @Option(name="-desc", aliases={"--userDescription"}, description="The user Description", required=false, multiValued=false)
    private String userDesc;
    @Option(name="-email", aliases={"--userEmail"}, description="The user email", required=false, multiValued=false)
    private String userEmail;

    @Override
    public Object execute() throws Exception {
        if (super.execute() == null) {
            return "User does not exist OR user name and passsword are not correct";
        }
        String domainId = DataStoreUtils.getDomainId(this.identityStore, this.domainName);
        if (domainId == null) {
            return "Domain does not exist";
        }
        User usr = new User();
        usr.setDescription(this.userDesc);
        usr.setDomainid(domainId);
        usr.setEnabled(true);
        usr.setEmail(this.userEmail);
        String pwd = CliUtils.readPassword("Enter new user password: ");
        if (pwd == null || pwd.isEmpty() || pwd.length() < 6) {
            return "Password should be at least 6 characters";
        }
        usr.setPassword(pwd);
        usr.setName(this.userName);
        usr = this.identityStore.writeUser(usr);
        if (usr != null) {
            if (this.roleName != null && !this.roleName.isEmpty()) {
                String roleId = DataStoreUtils.getRoleId(this.identityStore, this.roleName);
                if (roleId == null) {
                    return "User " + this.userName + " has been created, User Id is " + usr.getUserid() + ", Role does not exist";
                }
                Grant grant = new Grant();
                grant.setDomainid(domainId);
                grant.setRoleid(roleId);
                grant.setUserid(usr.getUserid());
                grant = this.identityStore.writeGrant(grant);
                if (grant == null) {
                    return "User " + usr.getName() + " has been created, User Id is " + usr.getUserid() + " but not granted to role " + this.roleName;
                }
                return "User " + usr.getName() + " has been created, User Id is " + usr.getUserid() + " and granted to role " + this.roleName;
            }
            return "User " + this.userName + " has been created, User Id is " + usr.getUserid();
        }
        return null;
    }
}

