/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.cli.AaaCliAbstractCommand;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@Service
@Command(name="add-role", scope="aaa", description="Add role.")
public class AddRole
extends AaaCliAbstractCommand {
    @Option(name="-name", aliases={"--roleName"}, description="The role name", required=true, multiValued=false)
    private String roleName;
    @Option(name="-dname", aliases={"--domainName"}, description="The domain name", required=true, multiValued=false)
    private String domainName;
    @Option(name="-desc", aliases={"--roleDescription"}, description="The role Description", required=true, multiValued=false)
    private String roleDesc;

    @Override
    public Object execute() throws Exception {
        if (super.execute() == null) {
            return "User does not exist OR user name and passsword are not correct";
        }
        Role role = new Role();
        role.setDescription(this.roleDesc);
        role.setName(this.roleName);
        String domainId = DataStoreUtils.getDomainId(this.identityStore, this.domainName);
        if (domainId == null) {
            return "Domain does not exist";
        }
        role.setDomainid(domainId);
        role = this.identityStore.writeRole(role);
        if (role != null) {
            return "Role " + this.roleName + " has been created, Role Id is " + role.getRoleid();
        }
        return null;
    }
}

