/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.cert;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.cert.api.ICertificateManager;

@Service
@Command(name="import-keystores", scope="aaa", description="Import default MD-SAL keystores, the keystores (odl and trust) should exist under default SSL directory configuration/ssl/")
public class ImportDefaultKeystores
implements Action {
    @Reference
    private ICertificateManager certProvider;
    @Option(name="-odlKeystoreName", aliases={"--"}, description="", required=true, multiValued=false)
    private String odlKeystoreName;
    @Option(name="-odlKeystoreAlias", aliases={"--"}, description="", required=true, multiValued=false)
    private String odlKeystoreAlias;
    @Option(name="-odlKeystorePwd", aliases={"--"}, description="", required=true, multiValued=false)
    private String odlKeystorePwd;
    @Option(name="-trustKeystoreName", aliases={"--"}, description="", required=true, multiValued=false)
    private String trustKeystoreName;
    @Option(name="-trustKeystorePwd", aliases={"--"}, description="", required=true, multiValued=false)
    private String trustKeystorePwd;
    @Option(name="-cipherSuites", aliases={"--"}, description="Different Cipher suites should be seperated by ','", required=true, multiValued=false)
    private String cipherSuitesStr;
    @Option(name="-tlsProtocols", aliases={"--"}, description="Different TLS protocols should be seperated by ','", required=true, multiValued=false)
    private String tlsProtocols;

    public Object execute() throws Exception {
        String[] cipherSuites = !this.cipherSuitesStr.isEmpty() ? (this.cipherSuitesStr.contains(",") ? this.cipherSuitesStr.split(",") : new String[]{this.cipherSuitesStr}) : new String[]{};
        if (this.certProvider.importSslDataKeystores(this.odlKeystoreName, this.odlKeystorePwd, this.odlKeystoreAlias, this.trustKeystoreName, this.trustKeystorePwd, cipherSuites, this.tlsProtocols)) {
            return "Default keystores successfully imported";
        }
        return "Failed to import the keystores";
    }
}

