/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.yang.types;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.CodegenEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.CodegenGeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.CodegenGeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.yang.types.AbstractTypeProvider;
import org.opendaylight.yangtools.yang.binding.RegexPatterns;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CodegenTypeProvider
extends AbstractTypeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CodegenTypeProvider.class);

    public CodegenTypeProvider(SchemaContext schemaContext, Map<SchemaNode, JavaTypeName> renames) {
        super(schemaContext, renames);
    }

    @VisibleForTesting
    CodegenTypeProvider(SchemaContext schemaContext) {
        this(schemaContext, (Map<SchemaNode, JavaTypeName>)ImmutableMap.of());
    }

    @Override
    public void addEnumDescription(EnumBuilder enumBuilder, EnumTypeDefinition enumTypeDef) {
        Optional optDesc = enumTypeDef.getDescription();
        if (optDesc.isPresent()) {
            enumBuilder.setDescription(BindingGeneratorUtil.encodeAngleBrackets((String)((String)optDesc.get())));
        }
    }

    @Override
    void addCodegenInformation(GeneratedTypeBuilderBase<?> genTOBuilder, TypeDefinition<?> typeDef) {
        Optional optDesc = typeDef.getDescription();
        if (optDesc.isPresent()) {
            genTOBuilder.setDescription(BindingGeneratorUtil.encodeAngleBrackets((String)((String)optDesc.get())));
        }
        typeDef.getReference().ifPresent(arg_0 -> genTOBuilder.setReference(arg_0));
    }

    @Override
    public Map<String, String> resolveRegExpressions(List<PatternConstraint> patternConstraints) {
        if (patternConstraints.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap regExps = Maps.newHashMapWithExpectedSize((int)patternConstraints.size());
        for (PatternConstraint patternConstraint : patternConstraints) {
            String regEx = patternConstraint.getJavaPatternString();
            Optional optModifier = patternConstraint.getModifier();
            if (optModifier.isPresent()) {
                regEx = CodegenTypeProvider.applyModifier((ModifierKind)optModifier.get(), regEx);
            }
            regExps.put(regEx, patternConstraint.getRegularExpressionString());
        }
        return regExps;
    }

    private static String applyModifier(ModifierKind modifier, String pattern) {
        switch (modifier) {
            case INVERT_MATCH: {
                return RegexPatterns.negatePatternString((String)pattern);
            }
        }
        LOG.warn("Ignoring unhandled modifier {}", (Object)modifier);
        return pattern;
    }

    @Override
    public GeneratedTOBuilder newGeneratedTOBuilder(JavaTypeName identifier) {
        return new CodegenGeneratedTOBuilder(identifier);
    }

    @Override
    public GeneratedTypeBuilder newGeneratedTypeBuilder(JavaTypeName identifier) {
        return new CodegenGeneratedTypeBuilder(identifier);
    }

    @Override
    public AbstractEnumerationBuilder newEnumerationBuilder(JavaTypeName identifier) {
        return new CodegenEnumerationBuilder(identifier);
    }
}

