/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.yang.types;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.opendaylight.mdsal.binding.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.util.Types;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

public final class BaseYangTypes {
    public static final Type BOOLEAN_TYPE;
    public static final Type EMPTY_TYPE;
    public static final Type ENUM_TYPE;
    public static final Type INT8_TYPE;
    public static final Type INT16_TYPE;
    public static final Type INT32_TYPE;
    public static final Type INT64_TYPE;
    public static final Type STRING_TYPE;
    public static final Type DECIMAL64_TYPE;
    public static final Type UINT8_TYPE;
    public static final Type UINT16_TYPE;
    public static final Type UINT32_TYPE;
    public static final Type UINT64_TYPE;
    public static final Type UNION_TYPE;
    public static final Type BINARY_TYPE;
    public static final Type INSTANCE_IDENTIFIER;
    private static final Map<String, Type> TYPE_MAP;
    public static final TypeProvider BASE_YANG_TYPES_PROVIDER;

    private BaseYangTypes() {
        throw new UnsupportedOperationException();
    }

    public static Type javaTypeForYangType(String type) {
        return TYPE_MAP.get(type);
    }

    private static <T extends Number> Restrictions singleRangeRestrictions(T min, T max) {
        return Types.getDefaultRestrictions(min, max);
    }

    static {
        EMPTY_TYPE = BOOLEAN_TYPE = Types.BOOLEAN;
        ENUM_TYPE = Types.typeForClass(Enum.class);
        INT8_TYPE = Types.typeForClass(Byte.class);
        INT16_TYPE = Types.typeForClass(Short.class);
        INT32_TYPE = Types.typeForClass(Integer.class);
        INT64_TYPE = Types.typeForClass(Long.class);
        STRING_TYPE = Types.STRING;
        DECIMAL64_TYPE = Types.typeForClass(BigDecimal.class);
        UINT8_TYPE = Types.typeForClass(Short.class, (Restrictions)BaseYangTypes.singleRangeRestrictions((short)0, (short)255));
        UINT16_TYPE = Types.typeForClass(Integer.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0, 65535));
        UINT32_TYPE = Types.typeForClass(Long.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0L, 0xFFFFFFFFL));
        UINT64_TYPE = Types.typeForClass(BigInteger.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(BigInteger.ZERO, new BigInteger("18446744073709551615")));
        UNION_TYPE = new UnionType();
        BINARY_TYPE = Types.typeForClass(byte[].class);
        INSTANCE_IDENTIFIER = Types.parameterizedTypeFor((Type)Types.typeForClass(InstanceIdentifier.class), (Type[])new Type[0]);
        TYPE_MAP = ImmutableMap.builder().put((Object)"boolean", (Object)BOOLEAN_TYPE).put((Object)"empty", (Object)EMPTY_TYPE).put((Object)"enumeration", (Object)ENUM_TYPE).put((Object)"int8", (Object)INT8_TYPE).put((Object)"int16", (Object)INT16_TYPE).put((Object)"int32", (Object)INT32_TYPE).put((Object)"int64", (Object)INT64_TYPE).put((Object)"string", (Object)STRING_TYPE).put((Object)"decimal64", (Object)DECIMAL64_TYPE).put((Object)"uint8", (Object)UINT8_TYPE).put((Object)"uint16", (Object)UINT16_TYPE).put((Object)"uint32", (Object)UINT32_TYPE).put((Object)"uint64", (Object)UINT64_TYPE).put((Object)"union", (Object)UNION_TYPE).put((Object)"binary", (Object)BINARY_TYPE).put((Object)"instance-identifier", (Object)INSTANCE_IDENTIFIER).build();
        BASE_YANG_TYPES_PROVIDER = new TypeProvider(){

            public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode, boolean lenientRelativeLeafrefs) {
                if (type != null) {
                    return (Type)TYPE_MAP.get(type.getQName().getLocalName());
                }
                return null;
            }

            public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode, Restrictions restrictions, boolean lenientRelativeLeafrefs) {
                String typeName;
                switch (typeName = type.getQName().getLocalName()) {
                    case "binary": {
                        return restrictions == null ? Types.BYTE_ARRAY : Types.typeForClass(byte[].class, (Restrictions)restrictions);
                    }
                    case "decimal64": {
                        return Types.typeForClass(BigDecimal.class, (Restrictions)restrictions);
                    }
                    case "enumeration": {
                        return Types.typeForClass(Enum.class, (Restrictions)restrictions);
                    }
                    case "int8": {
                        return Types.typeForClass(Byte.class, (Restrictions)restrictions);
                    }
                    case "int16": {
                        return Types.typeForClass(Short.class, (Restrictions)restrictions);
                    }
                    case "int32": {
                        return Types.typeForClass(Integer.class, (Restrictions)restrictions);
                    }
                    case "int64": {
                        return Types.typeForClass(Long.class, (Restrictions)restrictions);
                    }
                    case "string": {
                        return Types.typeForClass(String.class, (Restrictions)restrictions);
                    }
                    case "uint8": {
                        return Types.typeForClass(Short.class, (Restrictions)restrictions);
                    }
                    case "uint16": {
                        return Types.typeForClass(Integer.class, (Restrictions)restrictions);
                    }
                    case "uint32": {
                        return Types.typeForClass(Long.class, (Restrictions)restrictions);
                    }
                    case "uint64": {
                        return Types.typeForClass(BigInteger.class, (Restrictions)restrictions);
                    }
                    case "union": {
                        return UNION_TYPE;
                    }
                }
                return this.javaTypeForSchemaDefinitionType(type, parentNode, lenientRelativeLeafrefs);
            }

            public String getTypeDefaultConstruction(LeafSchemaNode node) {
                return null;
            }

            public String getConstructorPropertyName(SchemaNode node) {
                return null;
            }

            public String getParamNameFromType(TypeDefinition<?> type) {
                return "_" + BindingMapping.getPropertyName((String)type.getQName().getLocalName());
            }
        };
    }

    @Deprecated
    public static final class UnionType
    implements Type {
        public String getPackageName() {
            return null;
        }

        public String getName() {
            return "Union";
        }

        public String getFullyQualifiedName() {
            return "Union";
        }

        @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
        public JavaTypeName getIdentifier() {
            return null;
        }
    }
}

