/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.util;

import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.opendaylight.mdsal.binding.generator.util.SourceCodeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSourceCodeGenerator
implements SourceCodeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSourceCodeGenerator.class);
    private static final String GENERATED_SOURCE_DIR_PROP = "org.opendaylight.yangtools.sal.generatedCodecSourceDir";
    private final StringBuilder builder = new StringBuilder();
    private final String generatedSourceDir;

    public DefaultSourceCodeGenerator(String generatedSourceDir) {
        this.generatedSourceDir = generatedSourceDir != null ? generatedSourceDir : System.getProperty(GENERATED_SOURCE_DIR_PROP, "generated-codecs");
    }

    @Override
    public void appendField(CtField field, String value) {
        try {
            this.builder.append('\n').append(Modifier.toString((int)field.getModifiers())).append(' ').append(field.getType().getName()).append(' ').append(field.getName());
            if (value != null) {
                this.builder.append(" = ").append(value);
            }
            this.builder.append(";\n");
        }
        catch (NotFoundException e) {
            LOG.error("Error building field source for {}", (Object)field.getName(), (Object)e);
        }
    }

    @Override
    public void appendMethod(CtMethod method, String code) {
        try {
            this.builder.append('\n').append(Modifier.toString((int)method.getModifiers())).append(' ').append(method.getReturnType().getName()).append(' ').append(method.getName()).append("( ");
            CtClass[] paramTypes = method.getParameterTypes();
            if (paramTypes != null) {
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (i > 0) {
                        this.builder.append(", ");
                    }
                    this.builder.append(paramTypes[i].getName()).append(" $").append(i + 1);
                }
            }
            this.builder.append(" )\n").append(code).append("\n\n");
        }
        catch (NotFoundException e) {
            LOG.error("Error building method source for {}", (Object)method.getName(), (Object)e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public void outputGeneratedSource(CtClass ctClass) {
        String name = ctClass.getName();
        StringBuilder classBuilder = new StringBuilder();
        classBuilder.append(Modifier.toString((int)ctClass.getModifiers())).append(" class ").append(ctClass.getSimpleName());
        try {
            CtClass[] interfaces;
            CtClass superClass = ctClass.getSuperclass();
            if (superClass != null) {
                classBuilder.append(" extends ").append(superClass.getName());
            }
            if ((interfaces = ctClass.getInterfaces()).length > 0) {
                classBuilder.append(" implements ");
                for (int i = 0; i < interfaces.length; ++i) {
                    if (i > 0) {
                        classBuilder.append(", ");
                    }
                    classBuilder.append(interfaces[i].getName());
                }
            }
            classBuilder.append(" {\n").append((CharSequence)this.builder).append("\n}");
        }
        catch (NotFoundException e) {
            LOG.error("Error building class source for {}", (Object)name, (Object)e);
            return;
        }
        File dir = new File(this.generatedSourceDir);
        if (!dir.mkdir()) {
            LOG.warn("Failed to create directory {}, attempting to continue", (Object)this.generatedSourceDir);
        }
        try (BufferedWriter writer = Files.newWriter((File)new File(dir, name + ".java"), (Charset)StandardCharsets.UTF_8);){
            writer.append(classBuilder);
            writer.flush();
        }
        catch (IOException e) {
            LOG.error("Error writing class source for {}", (Object)name, (Object)e);
        }
    }
}

