/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.api.ModuleInfoRegistry;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleInfoBackedContext
extends GeneratedClassLoadingStrategy
implements ModuleInfoRegistry,
SchemaContextProvider,
SchemaSourceProvider<YangTextSchemaSource> {
    private final YangTextSchemaContextResolver ctxResolver = YangTextSchemaContextResolver.create((String)"binding-context");
    private static final Logger LOG = LoggerFactory.getLogger(ModuleInfoBackedContext.class);
    private final ConcurrentMap<String, WeakReference<ClassLoader>> packageNameToClassLoader = new ConcurrentHashMap<String, WeakReference<ClassLoader>>();
    private final ConcurrentMap<SourceIdentifier, YangModuleInfo> sourceIdentifierToModuleInfo = new ConcurrentHashMap<SourceIdentifier, YangModuleInfo>();
    private final ClassLoadingStrategy backingLoadingStrategy;

    private ModuleInfoBackedContext(ClassLoadingStrategy loadingStrategy) {
        this.backingLoadingStrategy = loadingStrategy;
    }

    public static ModuleInfoBackedContext create() {
        return new ModuleInfoBackedContext(ModuleInfoBackedContext.getTCCLClassLoadingStrategy());
    }

    public static ModuleInfoBackedContext create(ClassLoadingStrategy loadingStrategy) {
        return new ModuleInfoBackedContext(loadingStrategy);
    }

    @Override
    public Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
        ClassLoader classLoader;
        String modulePackageName = BindingReflections.getModelRootPackageName((String)fullyQualifiedName);
        WeakReference classLoaderRef = (WeakReference)this.packageNameToClassLoader.get(modulePackageName);
        if (classLoaderRef != null && (classLoader = (ClassLoader)classLoaderRef.get()) != null) {
            return ClassLoaderUtils.loadClass((ClassLoader)classLoader, (String)fullyQualifiedName);
        }
        if (this.backingLoadingStrategy == null) {
            throw new ClassNotFoundException(fullyQualifiedName);
        }
        Class cls = this.backingLoadingStrategy.loadClass(fullyQualifiedName);
        if (BindingReflections.isBindingClass((Class)cls)) {
            this.resolveModuleInfo(cls);
        }
        return cls;
    }

    public Optional<SchemaContext> tryToCreateSchemaContext() {
        return this.ctxResolver.getSchemaContext();
    }

    private boolean resolveModuleInfo(Class<?> cls) {
        try {
            return this.resolveModuleInfo(BindingReflections.getModuleInfo(cls));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to resolve module information for class %s", cls), e);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private boolean resolveModuleInfo(YangModuleInfo moduleInfo) {
        SourceIdentifier identifier = ModuleInfoBackedContext.sourceIdentifierFrom(moduleInfo);
        YangModuleInfo previous = this.sourceIdentifierToModuleInfo.putIfAbsent(identifier, moduleInfo);
        if (previous != null) {
            return false;
        }
        ClassLoader moduleClassLoader = moduleInfo.getClass().getClassLoader();
        try {
            String modulePackageName = moduleInfo.getClass().getPackage().getName();
            this.packageNameToClassLoader.putIfAbsent(modulePackageName, new WeakReference<ClassLoader>(moduleClassLoader));
            this.ctxResolver.registerSource(ModuleInfoBackedContext.toYangTextSource(identifier, moduleInfo));
            for (YangModuleInfo importedInfo : moduleInfo.getImportedModules()) {
                this.resolveModuleInfo(importedInfo);
            }
        }
        catch (Exception e) {
            LOG.error("Not including {} in YANG sources because of error.", (Object)moduleInfo, (Object)e);
        }
        return true;
    }

    private static YangTextSchemaSource toYangTextSource(SourceIdentifier identifier, YangModuleInfo moduleInfo) {
        return YangTextSchemaSource.delegateForByteSource((SourceIdentifier)identifier, (ByteSource)moduleInfo.getYangTextByteSource());
    }

    private static SourceIdentifier sourceIdentifierFrom(YangModuleInfo moduleInfo) {
        QName name = moduleInfo.getName();
        return RevisionSourceIdentifier.create((String)name.getLocalName(), (Optional)name.getRevision());
    }

    public void addModuleInfos(Iterable<? extends YangModuleInfo> moduleInfos) {
        for (YangModuleInfo yangModuleInfo : moduleInfos) {
            this.registerModuleInfo(yangModuleInfo);
        }
    }

    public ObjectRegistration<YangModuleInfo> registerModuleInfo(YangModuleInfo yangModuleInfo) {
        YangModuleInfoRegistration registration = new YangModuleInfoRegistration(yangModuleInfo, this);
        this.resolveModuleInfo(yangModuleInfo);
        return registration;
    }

    public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        YangModuleInfo yangModuleInfo = (YangModuleInfo)this.sourceIdentifierToModuleInfo.get(sourceIdentifier);
        if (yangModuleInfo == null) {
            LOG.debug("Unknown schema source requested: {}, available sources: {}", (Object)sourceIdentifier, this.sourceIdentifierToModuleInfo.keySet());
            return Futures.immediateFailedFuture((Throwable)new SchemaSourceException("Unknown schema source: " + sourceIdentifier));
        }
        return Futures.immediateFuture((Object)YangTextSchemaSource.delegateForByteSource((SourceIdentifier)sourceIdentifier, (ByteSource)yangModuleInfo.getYangTextByteSource()));
    }

    private void remove(YangModuleInfoRegistration registration) {
    }

    public SchemaContext getSchemaContext() {
        Optional<SchemaContext> contextOptional = this.tryToCreateSchemaContext();
        if (contextOptional.isPresent()) {
            return contextOptional.get();
        }
        throw new IllegalStateException("Unable to recreate SchemaContext, error while parsing");
    }

    private static class YangModuleInfoRegistration
    extends AbstractObjectRegistration<YangModuleInfo> {
        private final ModuleInfoBackedContext context;

        YangModuleInfoRegistration(YangModuleInfo instance, ModuleInfoBackedContext context) {
            super((Object)instance);
            this.context = context;
        }

        protected void removeRegistration() {
            this.context.remove(this);
        }
    }
}

