/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingSchemaContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BindingSchemaContextUtils.class);

    private BindingSchemaContextUtils() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static Optional<DataNodeContainer> findDataNodeContainer(SchemaContext ctx, InstanceIdentifier<?> path) {
        Iterator pathArguments = path.getPathArguments().iterator();
        InstanceIdentifier.PathArgument currentArg = (InstanceIdentifier.PathArgument)pathArguments.next();
        Preconditions.checkArgument((currentArg != null ? 1 : 0) != 0);
        QName currentQName = BindingReflections.findQName((Class)currentArg.getType());
        Optional<Object> currentContainer = Optional.empty();
        if (BindingReflections.isNotification((Class)currentArg.getType())) {
            currentContainer = BindingSchemaContextUtils.findNotification(ctx, currentQName);
        } else if (BindingReflections.isRpcType((Class)currentArg.getType())) {
            currentContainer = BindingSchemaContextUtils.findFirstDataNodeContainerInRpc(ctx, currentArg.getType());
            if (currentQName == null && currentContainer.isPresent()) {
                currentQName = ((DataSchemaNode)currentContainer.get()).getQName();
            }
        } else {
            currentContainer = BindingSchemaContextUtils.findDataNodeContainer((DataNodeContainer)ctx, currentQName);
        }
        while (currentContainer.isPresent() && pathArguments.hasNext()) {
            currentArg = (InstanceIdentifier.PathArgument)pathArguments.next();
            if (Augmentation.class.isAssignableFrom(currentArg.getType())) {
                currentQName = BindingReflections.findQName((Class)currentArg.getType());
                if (pathArguments.hasNext()) {
                    currentArg = (InstanceIdentifier.PathArgument)pathArguments.next();
                } else {
                    return currentContainer;
                }
            }
            currentQName = ChildOf.class.isAssignableFrom(currentArg.getType()) && BindingReflections.isAugmentationChild((Class)currentArg.getType()) ? BindingReflections.findQName((Class)currentArg.getType()) : BindingReflections.findQName((Class)currentArg.getType()).withModule(currentQName.getModule());
            Optional<DataNodeContainer> potential = BindingSchemaContextUtils.findDataNodeContainer((DataNodeContainer)currentContainer.get(), currentQName);
            if (potential.isPresent()) {
                currentContainer = potential;
                continue;
            }
            return Optional.empty();
        }
        return currentContainer;
    }

    private static Optional<DataNodeContainer> findDataNodeContainer(DataNodeContainer ctx, QName targetQName) {
        for (DataSchemaNode child : ctx.getChildNodes()) {
            if (child instanceof ChoiceSchemaNode) {
                DataNodeContainer potential = BindingSchemaContextUtils.findInCases((ChoiceSchemaNode)child, targetQName);
                if (potential == null) continue;
                return Optional.of(potential);
            }
            if (child instanceof DataNodeContainer && child.getQName().equals((Object)targetQName)) {
                return Optional.of((DataNodeContainer)child);
            }
            if (!(child instanceof DataNodeContainer) || !child.isAddedByUses() || !child.getQName().getLocalName().equals(targetQName.getLocalName())) continue;
            return Optional.of((DataNodeContainer)child);
        }
        return Optional.empty();
    }

    private static Optional<DataNodeContainer> findNotification(SchemaContext ctx, QName notificationQName) {
        for (NotificationDefinition notification : ctx.getNotifications()) {
            if (!notification.getQName().equals((Object)notificationQName)) continue;
            return Optional.of(notification);
        }
        return Optional.empty();
    }

    private static DataNodeContainer findInCases(ChoiceSchemaNode choiceNode, QName targetQName) {
        for (CaseSchemaNode caze : choiceNode.getCases().values()) {
            Optional<DataNodeContainer> potential = BindingSchemaContextUtils.findDataNodeContainer((DataNodeContainer)caze, targetQName);
            if (!potential.isPresent()) continue;
            return potential.get();
        }
        return null;
    }

    private static Optional<DataNodeContainer> findFirstDataNodeContainerInRpc(SchemaContext ctx, Class<? extends DataObject> targetType) {
        QNameModule targetModule;
        try {
            targetModule = BindingReflections.getModuleInfo(targetType).getName().getModule();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to load module information for class %s", targetType), e);
        }
        for (RpcDefinition rpc : ctx.getOperations()) {
            Optional<DataNodeContainer> potential;
            if (!targetModule.equals((Object)rpc.getQName().getModule()) || !(potential = BindingSchemaContextUtils.findInputOutput(rpc, targetType.getSimpleName())).isPresent()) continue;
            return potential;
        }
        return Optional.empty();
    }

    private static Optional<DataNodeContainer> findInputOutput(RpcDefinition rpc, String targetType) {
        String rpcName = BindingMapping.getClassName((QName)rpc.getQName());
        String rpcInputName = rpcName + "Input";
        if (targetType.equals(rpcInputName)) {
            return Optional.of(rpc.getInput());
        }
        String rpcOutputName = rpcName + "Output";
        if (targetType.equals(rpcOutputName)) {
            return Optional.of(rpc.getOutput());
        }
        return Optional.empty();
    }

    public static Set<AugmentationSchemaNode> collectAllAugmentationDefinitions(SchemaContext currentSchema, AugmentationTarget ctxNode) {
        HashSet<AugmentationSchemaNode> augmentations = new HashSet<AugmentationSchemaNode>();
        augmentations.addAll(ctxNode.getAvailableAugmentations());
        if (ctxNode instanceof DataSchemaNode && ((DataSchemaNode)ctxNode).isAddedByUses()) {
            LOG.info("DataSchemaNode target added by uses {}", (Object)ctxNode);
        }
        return augmentations;
    }

    public static Optional<ChoiceSchemaNode> findInstantiatedChoice(DataNodeContainer parent, Class<?> choiceClass) {
        return BindingSchemaContextUtils.findInstantiatedChoice(parent, BindingReflections.findQName(choiceClass));
    }

    public static Optional<ChoiceSchemaNode> findInstantiatedChoice(DataNodeContainer ctxNode, QName choiceName) {
        DataSchemaNode potential = ctxNode.getDataChildByName(choiceName);
        if (potential instanceof ChoiceSchemaNode) {
            return Optional.of((ChoiceSchemaNode)potential);
        }
        return Optional.empty();
    }

    public static Optional<CaseSchemaNode> findInstantiatedCase(ChoiceSchemaNode instantiatedChoice, CaseSchemaNode originalDefinition) {
        SchemaNode potentialRoot;
        CaseSchemaNode potential = instantiatedChoice.getCaseNodeByName(originalDefinition.getQName());
        if (originalDefinition.equals(potential)) {
            return Optional.of(potential);
        }
        if (potential != null && originalDefinition.equals(potentialRoot = SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)potential))) {
            return Optional.of(potential);
        }
        for (CaseSchemaNode caze : instantiatedChoice.findCaseNodes(originalDefinition.getQName().getLocalName())) {
            if (!originalDefinition.equals(SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)caze))) continue;
            return Optional.of(caze);
        }
        return Optional.empty();
    }
}

