/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.impl.DeploymentMetadataImpl;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.ManifestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentMetadataFactoryImpl
implements DeploymentMetadataFactory {
    public DeploymentMetadata createDeploymentMetadata(AriesApplication app, Set<BundleInfo> additionalBundlesRequired) throws ResolverException {
        return new DeploymentMetadataImpl(app, additionalBundlesRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentMetadata parseDeploymentMetadata(IFile src) throws IOException {
        InputStream is = src.open();
        try {
            DeploymentMetadata deploymentMetadata = this.parseDeploymentMetadata(is);
            return deploymentMetadata;
        }
        finally {
            IOUtils.close((Closeable)is);
        }
    }

    public DeploymentMetadata parseDeploymentMetadata(InputStream in) throws IOException {
        return this.createDeploymentMetadata(ManifestProcessor.parseManifest((InputStream)in));
    }

    public DeploymentMetadata createDeploymentMetadata(Manifest manifest) throws IOException {
        try {
            return new DeploymentMetadataImpl(manifest);
        }
        catch (InvalidAttributeException iae) {
            IOException e = new IOException();
            e.initCause(iae);
            throw e;
        }
    }

    public DeploymentMetadata createDeploymentMetadata(IFile src) throws IOException {
        return this.parseDeploymentMetadata(src);
    }

    public DeploymentMetadata createDeploymentMetadata(InputStream in) throws IOException {
        return this.parseDeploymentMetadata(in);
    }
}

