/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.aries.application.Content;
import org.apache.aries.application.utils.internal.MessageUtil;
import org.apache.aries.util.VersionRange;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentImpl
implements Content {
    private String contentName;
    protected Map<String, String> attributes;
    private Map<String, String> directives;
    private Map<String, String> nameValueMap;

    public ContentImpl(String content) {
        block1: {
            Map appContentsMap = ManifestHeaderProcessor.parseImportString((String)content);
            if (appContentsMap.size() != 1) {
                throw new IllegalArgumentException(MessageUtil.getMessage("APPUTILS0004E", content));
            }
            Iterator i$ = appContentsMap.entrySet().iterator();
            if (!i$.hasNext()) break block1;
            Map.Entry entry = i$.next();
            this.contentName = (String)entry.getKey();
            this.nameValueMap = (Map)entry.getValue();
            this.setup();
        }
    }

    public ContentImpl(String bundleSymbolicName, Version version) {
        this.contentName = bundleSymbolicName;
        this.nameValueMap = new HashMap<String, String>();
        this.nameValueMap.put("version", version.toString());
        this.setup();
    }

    public ContentImpl(String bundleSymbolicName, VersionRange version) {
        this.contentName = bundleSymbolicName;
        this.nameValueMap = new HashMap<String, String>();
        this.nameValueMap.put("version", version.toString());
        this.setup();
    }

    public ContentImpl(String contentName, Map<String, String> nameValueMap) {
        this.contentName = contentName;
        this.nameValueMap = nameValueMap;
        this.setup();
    }

    public String getContentName() {
        return this.contentName;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getAttribute(String key) {
        String toReturn = this.attributes.get(key);
        return toReturn;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getDirective(String key) {
        String toReturn = this.directives.get(key);
        return toReturn;
    }

    public Map<String, String> getNameValueMap() {
        HashMap<String, String> nvm = new HashMap<String, String>();
        for (String key : this.nameValueMap.keySet()) {
            nvm.put(key, this.nameValueMap.get(key));
        }
        return nvm;
    }

    public void addDirective(String key, String value) {
        this.directives.put(key, value);
    }

    public VersionRange getVersion() {
        VersionRange vi = null;
        vi = this.attributes.get("version") != null && this.attributes.get("version").length() > 0 ? ManifestHeaderProcessor.parseVersionRange((String)this.attributes.get("version")) : ManifestHeaderProcessor.parseVersionRange((String)"0.0.0");
        return vi;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.contentName);
        if (!this.nameValueMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.nameValueMap.entrySet()) {
                builder.append(';');
                builder.append(entry.getKey());
                builder.append('=').append('\"');
                builder.append(entry.getValue());
                builder.append('\"');
            }
        }
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ContentImpl) {
            ContentImpl otherContent = (ContentImpl)other;
            Map<String, String> attributesWithoutVersion = this.attributes;
            if (this.attributes.containsKey("version")) {
                attributesWithoutVersion = new HashMap<String, String>(this.attributes);
                attributesWithoutVersion.remove("version");
            }
            Map<String, String> otherAttributesWithoutVersion = otherContent.attributes;
            if (otherContent.attributes.containsKey("version")) {
                otherAttributesWithoutVersion = new HashMap<String, String>(otherContent.attributes);
                otherAttributesWithoutVersion.remove("version");
            }
            return this.contentName.equals(otherContent.contentName) && ((Object)attributesWithoutVersion).equals(otherAttributesWithoutVersion) && ((Object)this.directives).equals(otherContent.directives) && this.getVersion().equals((Object)otherContent.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return this.contentName.hashCode();
    }

    protected void setup() {
        this.attributes = new HashMap<String, String>();
        this.directives = new HashMap<String, String>();
        for (String key : this.nameValueMap.keySet()) {
            if (key.endsWith(":")) {
                this.directives.put(key.substring(0, key.length() - 1), this.nameValueMap.get(key));
                continue;
            }
            this.attributes.put(key, this.nameValueMap.get(key));
        }
    }
}

