/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import org.apache.karaf.jms.JmsMessage;
import org.apache.karaf.jms.JmsService;
import org.apache.karaf.jms.internal.ActiveMQDestinationSourceFactory;
import org.apache.karaf.jms.internal.ArtemisDestinationSourceFactory;
import org.apache.karaf.jms.internal.DestinationSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class JmsServiceImpl
implements JmsService {
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;
    private Path deployFolder = Paths.get(System.getProperty("karaf.base"), "deploy");

    @Override
    public void create(String name, String type, String url) throws Exception {
        this.create(name, type, url, null, null, "jmspooled");
    }

    @Override
    public void create(String name, String type, String url, String username, String password, String pool) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("JMS connection factory type not known");
        }
        if (this.connectionFactories().contains(name)) {
            throw new IllegalArgumentException("There is already a ConnectionFactory with the name " + name);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.jndi.service.name", "jms/" + name);
        ((Dictionary)properties).put("name", name);
        ((Dictionary)properties).put("type", type);
        this.put(properties, "url", url);
        this.put(properties, "user", username);
        this.put(properties, "password", password);
        if (pool.equals("narayana")) {
            this.put(properties, "pool", "narayana");
        }
        if (pool.equals("transx") || type.equalsIgnoreCase("activemq")) {
            this.put(properties, "pool", "transx");
        }
        Configuration config = this.configAdmin.createFactoryConfiguration("org.ops4j.connectionfactory", null);
        config.update(properties);
    }

    private void put(Dictionary<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    @Override
    public void delete(String name) throws Exception {
        Configuration[] configs;
        String filter = String.format("(&(service.factoryPid=org.ops4j.connectionfactory)(%s=%s))", "name", name);
        for (Configuration config : configs = this.configAdmin.listConfigurations(filter)) {
            config.delete();
        }
    }

    @Override
    public List<String> connectionFactories() throws Exception {
        return this.bundleContext.getServiceReferences(ConnectionFactory.class, null).stream().map(this::getConnectionFactoryName).distinct().collect(Collectors.toList());
    }

    private String getConnectionFactoryName(ServiceReference<ConnectionFactory> reference) {
        if (reference.getProperty("osgi.jndi.service.name") != null) {
            return (String)reference.getProperty("osgi.jndi.service.name");
        }
        if (reference.getProperty("name") != null) {
            return (String)reference.getProperty("name");
        }
        return reference.getProperty("service.id").toString();
    }

    @Override
    public List<String> connectionFactoryFileNames() throws Exception {
        return Files.list(this.deployFolder).map(Path::getFileName).map(Path::toString).filter(name -> name.startsWith("connectionfactory-") && name.endsWith(".xml")).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> info(String connectionFactory, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            ConnectionMetaData metaData = context.getMetaData();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("product", metaData.getJMSProviderName());
            map.put("version", metaData.getProviderVersion());
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int count(String connectionFactory, String destination, String username, String password) throws IOException, JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JMSContext createContext(String name, String username, String password) {
        return this.createContext(name, username, password, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSContext createContext(String name, String username, String password, int sessionMode) {
        ServiceReference<ConnectionFactory> sr = this.lookupConnectionFactory(name);
        ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(sr);
        try {
            JMSContext jMSContext = cf.createContext(username, password, sessionMode);
            return jMSContext;
        }
        finally {
            this.bundleContext.ungetService(sr);
        }
    }

    private ServiceReference<ConnectionFactory> lookupConnectionFactory(String name) {
        try {
            Collection references = this.bundleContext.getServiceReferences(ConnectionFactory.class, "(|(osgi.jndi.service.name=" + name + ")(name=" + name + ")(service.id=" + name + "))");
            return (ServiceReference)references.stream().sorted(Comparator.naturalOrder().reversed()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JMS connection factory found for " + name));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Error finding connection factory service " + name, e);
        }
    }

    private DestinationSource getDestinationSource(JMSContext context) throws JMSException {
        DestinationSource.Factory factory;
        List<DestinationSource.Factory> factories = Arrays.asList(new ActiveMQDestinationSourceFactory(), new ArtemisDestinationSourceFactory());
        DestinationSource source = null;
        Iterator<DestinationSource.Factory> iterator = factories.iterator();
        while (iterator.hasNext() && (source = (factory = iterator.next()).create(context)) == null) {
        }
        if (source == null) {
            source = d -> Collections.emptyList();
        }
        return source;
    }

    @Override
    public List<String> queues(String connectionFactory, String username, String password) throws JMSException, IOException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            List<String> list = this.getDestinationSource(context).getNames(DestinationSource.DestinationType.Queue);
            return list;
        }
    }

    @Override
    public List<String> topics(String connectionFactory, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            List<String> list = this.getDestinationSource(context).getNames(DestinationSource.DestinationType.Topic);
            return list;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<JmsMessage> browse(String connectionFactory, String queue, String filter, String username, String password) throws JMSException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void send(String connectionFactory, String queue, String body, String replyTo, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            JMSProducer producer = context.createProducer();
            if (replyTo != null) {
                producer.setJMSReplyTo((Destination)context.createQueue(replyTo));
            }
            producer.send((Destination)context.createQueue(queue), body);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int consume(String connectionFactory, String queue, String selector, String username, String password) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int move(String connectionFactory, String sourceQueue, String targetQueue, String selector, String username, String password) throws IOException, JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

