/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.karaf.jms.internal.DestinationSource;

class ActiveMQDestinationSourceFactory
implements DestinationSource.Factory {
    ActiveMQDestinationSourceFactory() {
    }

    @Override
    public DestinationSource create(JMSContext context) {
        try {
            ConnectionMetaData cmd = context.getMetaData();
            if (cmd.getJMSProviderName().equals("ActiveMQ") && cmd.getProviderVersion().startsWith("5.")) {
                return type -> this.getNames(context, type);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getNames(JMSContext context, DestinationSource.DestinationType type) {
        try {
            ArrayList<String> names = new ArrayList<String>();
            context.start();
            String dest = "ActiveMQ.Advisory." + (type == DestinationSource.DestinationType.Queue ? "Queue" : "Topic");
            try (JMSConsumer consumer = context.createConsumer((Destination)context.createTopic(dest));){
                while (true) {
                    Message message;
                    if ((message = consumer.receive(100L)) == null) {
                        ArrayList<String> arrayList = names;
                        return arrayList;
                    }
                    Destination destination = (Destination)ActiveMQDestinationSourceFactory.getField(message, "super.dataStructure", "destination");
                    if (destination instanceof Queue) {
                        names.add(((Queue)destination).getQueueName());
                        continue;
                    }
                    names.add(((Topic)destination).getTopicName());
                    continue;
                    break;
                }
            }
        }
        catch (Exception e) {
            String string = e.toString();
            return Collections.emptyList();
        }
    }

    private static Object getField(Object context, String ... fields) throws NoSuchFieldException, IllegalAccessException {
        Object obj = context;
        for (String field : fields) {
            Class<?> cl = obj.getClass();
            while (field.startsWith("super.")) {
                cl = cl.getSuperclass();
                field = field.substring("super.".length());
            }
            Field f = cl.getDeclaredField(field);
            f.setAccessible(true);
            obj = f.get(obj);
        }
        return obj;
    }
}

