/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.ospf.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.TedLinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.Srlg;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.UnreservedBandwidth;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.ospf.link.attributes.Ted;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TedBuilder
implements Builder<Ted> {
    private Long _color;
    private BigDecimal _maxLinkBandwidth;
    private BigDecimal _maxResvLinkBandwidth;
    private Srlg _srlg;
    private Long _teDefaultMetric;
    private List<UnreservedBandwidth> _unreservedBandwidth;
    Map<Class<? extends Augmentation<Ted>>, Augmentation<Ted>> augmentation = Collections.emptyMap();

    public TedBuilder() {
    }

    public TedBuilder(TedLinkAttributes arg) {
        this._color = arg.getColor();
        this._maxLinkBandwidth = arg.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = arg.getMaxResvLinkBandwidth();
        this._unreservedBandwidth = arg.getUnreservedBandwidth();
        this._teDefaultMetric = arg.getTeDefaultMetric();
        this._srlg = arg.getSrlg();
    }

    public TedBuilder(Ted base) {
        Map aug;
        this._color = base.getColor();
        this._maxLinkBandwidth = base.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
        this._srlg = base.getSrlg();
        this._teDefaultMetric = base.getTeDefaultMetric();
        this._unreservedBandwidth = base.getUnreservedBandwidth();
        if (base instanceof TedImpl) {
            TedImpl impl = (TedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TedLinkAttributes) {
            this._color = ((TedLinkAttributes)arg).getColor();
            this._maxLinkBandwidth = ((TedLinkAttributes)arg).getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = ((TedLinkAttributes)arg).getMaxResvLinkBandwidth();
            this._unreservedBandwidth = ((TedLinkAttributes)arg).getUnreservedBandwidth();
            this._teDefaultMetric = ((TedLinkAttributes)arg).getTeDefaultMetric();
            this._srlg = ((TedLinkAttributes)arg).getSrlg();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.TedLinkAttributes]");
    }

    public Long getColor() {
        return this._color;
    }

    public BigDecimal getMaxLinkBandwidth() {
        return this._maxLinkBandwidth;
    }

    public BigDecimal getMaxResvLinkBandwidth() {
        return this._maxResvLinkBandwidth;
    }

    public Srlg getSrlg() {
        return this._srlg;
    }

    public Long getTeDefaultMetric() {
        return this._teDefaultMetric;
    }

    public List<UnreservedBandwidth> getUnreservedBandwidth() {
        return this._unreservedBandwidth;
    }

    public <E$$ extends Augmentation<Ted>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkColorRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public TedBuilder setColor(Long value) {
        if (value != null) {
            TedBuilder.checkColorRange(value);
        }
        this._color = value;
        return this;
    }

    public TedBuilder setMaxLinkBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._maxLinkBandwidth = value;
        return this;
    }

    public TedBuilder setMaxResvLinkBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._maxResvLinkBandwidth = value;
        return this;
    }

    public TedBuilder setSrlg(Srlg value) {
        this._srlg = value;
        return this;
    }

    private static void checkTeDefaultMetricRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public TedBuilder setTeDefaultMetric(Long value) {
        if (value != null) {
            TedBuilder.checkTeDefaultMetricRange(value);
        }
        this._teDefaultMetric = value;
        return this;
    }

    public TedBuilder setUnreservedBandwidth(List<UnreservedBandwidth> values) {
        this._unreservedBandwidth = values;
        return this;
    }

    public TedBuilder addAugmentation(Class<? extends Augmentation<Ted>> augmentationType, Augmentation<Ted> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TedBuilder removeAugmentation(Class<? extends Augmentation<Ted>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ted build() {
        return new TedImpl(this);
    }

    private static final class TedImpl
    implements Ted {
        private final Long _color;
        private final BigDecimal _maxLinkBandwidth;
        private final BigDecimal _maxResvLinkBandwidth;
        private final Srlg _srlg;
        private final Long _teDefaultMetric;
        private final List<UnreservedBandwidth> _unreservedBandwidth;
        private Map<Class<? extends Augmentation<Ted>>, Augmentation<Ted>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TedImpl(TedBuilder base) {
            this._color = base.getColor();
            this._maxLinkBandwidth = base.getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
            this._srlg = base.getSrlg();
            this._teDefaultMetric = base.getTeDefaultMetric();
            this._unreservedBandwidth = base.getUnreservedBandwidth();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Ted> getImplementedInterface() {
            return Ted.class;
        }

        public Long getColor() {
            return this._color;
        }

        public BigDecimal getMaxLinkBandwidth() {
            return this._maxLinkBandwidth;
        }

        public BigDecimal getMaxResvLinkBandwidth() {
            return this._maxResvLinkBandwidth;
        }

        public Srlg getSrlg() {
            return this._srlg;
        }

        public Long getTeDefaultMetric() {
            return this._teDefaultMetric;
        }

        public List<UnreservedBandwidth> getUnreservedBandwidth() {
            return this._unreservedBandwidth;
        }

        public <E$$ extends Augmentation<Ted>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._color);
            result = 31 * result + Objects.hashCode(this._maxLinkBandwidth);
            result = 31 * result + Objects.hashCode(this._maxResvLinkBandwidth);
            result = 31 * result + Objects.hashCode(this._srlg);
            result = 31 * result + Objects.hashCode(this._teDefaultMetric);
            result = 31 * result + Objects.hashCode(this._unreservedBandwidth);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ted.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ted other = (Ted)obj;
            if (!Objects.equals(this._color, other.getColor())) {
                return false;
            }
            if (!Objects.equals(this._maxLinkBandwidth, other.getMaxLinkBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._maxResvLinkBandwidth, other.getMaxResvLinkBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._srlg, other.getSrlg())) {
                return false;
            }
            if (!Objects.equals(this._teDefaultMetric, other.getTeDefaultMetric())) {
                return false;
            }
            if (!Objects.equals(this._unreservedBandwidth, other.getUnreservedBandwidth())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TedImpl otherImpl = (TedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ted>>, Augmentation<Ted>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Ted");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_color", (Object)this._color);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxLinkBandwidth", (Object)this._maxLinkBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxResvLinkBandwidth", (Object)this._maxResvLinkBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_srlg", (Object)this._srlg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_teDefaultMetric", (Object)this._teDefaultMetric);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_unreservedBandwidth", this._unreservedBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

