/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.db2.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class DB2DataSourceFactory
implements DataSourceFactory {
    public static final String DB2_DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static final String DB2_DATASOURCE_CLASS = "com.ibm.db2.jcc.DB2SimpleDataSource";
    private static final String DB2_CONNECTIONPOOL_DATASOURCE_CLASS = "com.ibm.db2.jcc.DB2ConnectionPoolDataSource";
    private static final String DB2_XA_DATASOURCE_CLASS = "com.ibm.db2.jcc.DB2XADataSource";
    private final Class<? extends DataSource> db2DataSourceClass;
    private final Class<? extends ConnectionPoolDataSource> db2ConnectionPoolDataSourceClass;
    private final Class<? extends XADataSource> db2XaDataSourceClass;
    private final Class<?> db2DriverClass;

    public DB2DataSourceFactory() throws ClassNotFoundException {
        ClassLoader classLoader = DB2DataSourceFactory.class.getClassLoader();
        this.db2DataSourceClass = classLoader.loadClass(DB2_DATASOURCE_CLASS);
        this.db2ConnectionPoolDataSourceClass = classLoader.loadClass(DB2_CONNECTIONPOOL_DATASOURCE_CLASS);
        this.db2XaDataSourceClass = classLoader.loadClass(DB2_XA_DATASOURCE_CLASS);
        this.db2DriverClass = classLoader.loadClass(DB2_DRIVER_CLASS);
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        return DB2DataSourceFactory.create(this.db2DataSourceClass, props);
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        return DB2DataSourceFactory.create(this.db2ConnectionPoolDataSourceClass, props);
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        return DB2DataSourceFactory.create(this.db2XaDataSourceClass, props);
    }

    private static <T extends CommonDataSource> T create(Class<T> target, Properties props) throws SQLException {
        try {
            CommonDataSource ds = (CommonDataSource)target.cast(target.newInstance());
            BeanConfig.configure((Object)ds, props);
            return (T)ds;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public Driver createDriver(Properties props) throws SQLException {
        try {
            return (Driver)Driver.class.cast(this.db2DriverClass.newInstance());
        }
        catch (InstantiationException ex) {
            throw new SQLException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new SQLException(ex);
        }
    }
}

