/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.streams.stream;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.streams.stream.Access;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.streams.stream.AccessKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AccessBuilder
implements Builder<Access> {
    private String _encoding;
    private Uri _location;
    private AccessKey key;
    Map<Class<? extends Augmentation<Access>>, Augmentation<Access>> augmentation = Collections.emptyMap();

    public AccessBuilder() {
    }

    public AccessBuilder(Access base) {
        Map aug;
        this.key = base.key();
        this._encoding = base.getEncoding();
        this._location = base.getLocation();
        if (base instanceof AccessImpl) {
            AccessImpl impl = (AccessImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Access>>, Augmentation<Access>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Access>>, Augmentation<Access>>(aug);
        }
    }

    public AccessKey key() {
        return this.key;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public Uri getLocation() {
        return this._location;
    }

    public <E$$ extends Augmentation<Access>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AccessBuilder withKey(AccessKey key) {
        this.key = key;
        return this;
    }

    public AccessBuilder setEncoding(String value) {
        this._encoding = value;
        return this;
    }

    public AccessBuilder setLocation(Uri value) {
        this._location = value;
        return this;
    }

    public AccessBuilder addAugmentation(Class<? extends Augmentation<Access>> augmentationType, Augmentation<Access> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Access>>, Augmentation<Access>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AccessBuilder removeAugmentation(Class<? extends Augmentation<Access>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Access build() {
        return new AccessImpl(this);
    }

    private static final class AccessImpl
    implements Access {
        private final String _encoding;
        private final Uri _location;
        private final AccessKey key;
        private Map<Class<? extends Augmentation<Access>>, Augmentation<Access>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AccessImpl(AccessBuilder base) {
            this.key = base.key() != null ? base.key() : new AccessKey(base.getEncoding());
            this._encoding = this.key.getEncoding();
            this._location = base.getLocation();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Access> getImplementedInterface() {
            return Access.class;
        }

        @Override
        public AccessKey key() {
            return this.key;
        }

        @Override
        public String getEncoding() {
            return this._encoding;
        }

        @Override
        public Uri getLocation() {
            return this._location;
        }

        public <E$$ extends Augmentation<Access>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._encoding);
            result = 31 * result + Objects.hashCode(this._location);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Access.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Access other = (Access)obj;
            if (!Objects.equals(this._encoding, other.getEncoding())) {
                return false;
            }
            if (!Objects.equals(this._location, other.getLocation())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AccessImpl otherImpl = (AccessImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Access>>, Augmentation<Access>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Access");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encoding", (Object)this._encoding);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_location", (Object)this._location);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

