/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.streams;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.streams.StreamKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.streams.stream.Access;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StreamBuilder
implements Builder<Stream> {
    private List<Access> _access;
    private String _description;
    private String _name;
    private DateAndTime _replayLogCreationTime;
    private Boolean _replaySupport;
    private StreamKey key;
    Map<Class<? extends Augmentation<Stream>>, Augmentation<Stream>> augmentation = Collections.emptyMap();

    public StreamBuilder() {
    }

    public StreamBuilder(Stream base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._access = base.getAccess();
        this._description = base.getDescription();
        this._replayLogCreationTime = base.getReplayLogCreationTime();
        this._replaySupport = base.isReplaySupport();
        if (base instanceof StreamImpl) {
            StreamImpl impl = (StreamImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Stream>>, Augmentation<Stream>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Stream>>, Augmentation<Stream>>(aug);
        }
    }

    public StreamKey key() {
        return this.key;
    }

    public List<Access> getAccess() {
        return this._access;
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public DateAndTime getReplayLogCreationTime() {
        return this._replayLogCreationTime;
    }

    public Boolean isReplaySupport() {
        return this._replaySupport;
    }

    public <E$$ extends Augmentation<Stream>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public StreamBuilder withKey(StreamKey key) {
        this.key = key;
        return this;
    }

    public StreamBuilder setAccess(List<Access> values) {
        this._access = values;
        return this;
    }

    public StreamBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public StreamBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public StreamBuilder setReplayLogCreationTime(DateAndTime value) {
        this._replayLogCreationTime = value;
        return this;
    }

    public StreamBuilder setReplaySupport(Boolean value) {
        this._replaySupport = value;
        return this;
    }

    public StreamBuilder addAugmentation(Class<? extends Augmentation<Stream>> augmentationType, Augmentation<Stream> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Stream>>, Augmentation<Stream>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StreamBuilder removeAugmentation(Class<? extends Augmentation<Stream>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Stream build() {
        return new StreamImpl(this);
    }

    private static final class StreamImpl
    implements Stream {
        private final List<Access> _access;
        private final String _description;
        private final String _name;
        private final DateAndTime _replayLogCreationTime;
        private final Boolean _replaySupport;
        private final StreamKey key;
        private Map<Class<? extends Augmentation<Stream>>, Augmentation<Stream>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StreamImpl(StreamBuilder base) {
            this.key = base.key() != null ? base.key() : new StreamKey(base.getName());
            this._name = this.key.getName();
            this._access = base.getAccess();
            this._description = base.getDescription();
            this._replayLogCreationTime = base.getReplayLogCreationTime();
            this._replaySupport = base.isReplaySupport();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Stream> getImplementedInterface() {
            return Stream.class;
        }

        @Override
        public StreamKey key() {
            return this.key;
        }

        @Override
        public List<Access> getAccess() {
            return this._access;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public DateAndTime getReplayLogCreationTime() {
            return this._replayLogCreationTime;
        }

        @Override
        public Boolean isReplaySupport() {
            return this._replaySupport;
        }

        public <E$$ extends Augmentation<Stream>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._access);
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._replayLogCreationTime);
            result = 31 * result + Objects.hashCode(this._replaySupport);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Stream.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Stream other = (Stream)obj;
            if (!Objects.equals(this._access, other.getAccess())) {
                return false;
            }
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._replayLogCreationTime, other.getReplayLogCreationTime())) {
                return false;
            }
            if (!Objects.equals(this._replaySupport, other.isReplaySupport())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StreamImpl otherImpl = (StreamImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Stream>>, Augmentation<Stream>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Stream");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_access", this._access);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_description", (Object)this._description);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_replayLogCreationTime", (Object)this._replayLogCreationTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_replaySupport", (Object)this._replaySupport);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

