/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.RestconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.restconf.state.Streams;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RestconfStateBuilder
implements Builder<RestconfState> {
    private Capabilities _capabilities;
    private Streams _streams;
    Map<Class<? extends Augmentation<RestconfState>>, Augmentation<RestconfState>> augmentation = Collections.emptyMap();

    public RestconfStateBuilder() {
    }

    public RestconfStateBuilder(RestconfState base) {
        Map aug;
        this._capabilities = base.getCapabilities();
        this._streams = base.getStreams();
        if (base instanceof RestconfStateImpl) {
            RestconfStateImpl impl = (RestconfStateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RestconfState>>, Augmentation<RestconfState>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RestconfState>>, Augmentation<RestconfState>>(aug);
        }
    }

    public Capabilities getCapabilities() {
        return this._capabilities;
    }

    public Streams getStreams() {
        return this._streams;
    }

    public <E$$ extends Augmentation<RestconfState>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RestconfStateBuilder setCapabilities(Capabilities value) {
        this._capabilities = value;
        return this;
    }

    public RestconfStateBuilder setStreams(Streams value) {
        this._streams = value;
        return this;
    }

    public RestconfStateBuilder addAugmentation(Class<? extends Augmentation<RestconfState>> augmentationType, Augmentation<RestconfState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RestconfState>>, Augmentation<RestconfState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RestconfStateBuilder removeAugmentation(Class<? extends Augmentation<RestconfState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RestconfState build() {
        return new RestconfStateImpl(this);
    }

    private static final class RestconfStateImpl
    implements RestconfState {
        private final Capabilities _capabilities;
        private final Streams _streams;
        private Map<Class<? extends Augmentation<RestconfState>>, Augmentation<RestconfState>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RestconfStateImpl(RestconfStateBuilder base) {
            this._capabilities = base.getCapabilities();
            this._streams = base.getStreams();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<RestconfState> getImplementedInterface() {
            return RestconfState.class;
        }

        @Override
        public Capabilities getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Streams getStreams() {
            return this._streams;
        }

        public <E$$ extends Augmentation<RestconfState>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._capabilities);
            result = 31 * result + Objects.hashCode(this._streams);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RestconfState.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RestconfState other = (RestconfState)obj;
            if (!Objects.equals(this._capabilities, other.getCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._streams, other.getStreams())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RestconfStateImpl otherImpl = (RestconfStateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RestconfState>>, Augmentation<RestconfState>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"RestconfState");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_capabilities", (Object)this._capabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_streams", (Object)this._streams);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

