/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;

@Immutable
public interface SchemaContext
extends ContainerSchemaNode {
    public static final @NonNull QName NAME = QName.create((URI)URI.create("urn:ietf:params:xml:ns:netconf:base:1.0"), (String)"data").intern();

    public Set<DataSchemaNode> getDataDefinitions();

    public Set<Module> getModules();

    public Set<RpcDefinition> getOperations();

    public Set<ExtensionDefinition> getExtensions();

    public Optional<Module> findModule(@NonNull QNameModule var1);

    default public Optional<Module> findModule(@NonNull URI namespace) {
        return this.findModule(QNameModule.create((URI)namespace));
    }

    default public Optional<Module> findModule(@NonNull URI namespace, @Nullable Revision revision) {
        return this.findModule(QNameModule.create((URI)namespace, (Revision)revision));
    }

    default public Optional<Module> findModule(@NonNull URI namespace, @NonNull Optional<Revision> revision) {
        return this.findModule(QNameModule.create((URI)namespace, revision));
    }

    default public Optional<Module> findModule(String name, Optional<Revision> revision) {
        return this.findModules(name).stream().filter(module -> revision.equals(module.getRevision())).findAny();
    }

    default public Optional<Module> findModule(String name, @Nullable Revision revision) {
        return this.findModule(name, Optional.ofNullable(revision));
    }

    default public Optional<Module> findModule(String name) {
        return this.findModule(name, Optional.empty());
    }

    default public Set<Module> findModules(String name) {
        return Sets.filter(this.getModules(), m -> name.equals(m.getName()));
    }

    default public Set<Module> findModules(URI namespace) {
        return Sets.filter(this.getModules(), m -> namespace.equals(m.getNamespace()));
    }

    @Override
    default public Set<ActionDefinition> getActions() {
        return ImmutableSet.of();
    }

    @Override
    default public Optional<String> getDescription() {
        return Optional.empty();
    }

    @Override
    default public Optional<String> getReference() {
        return Optional.empty();
    }

    @Override
    default public Collection<MustDefinition> getMustConstraints() {
        return ImmutableSet.of();
    }

    @Override
    default public Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.empty();
    }

    @Override
    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(QName name) {
        return this.findModule(name.getModule()).flatMap(mod -> mod.findDataTreeChild(name));
    }
}

