/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.osgi.impl;

import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.binding.dom.codec.osgi.impl.SimpleBindingRuntimeContextService;
import org.opendaylight.mdsal.binding.generator.api.ModuleInfoRegistry;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OsgiModuleInfoRegistry
implements ModuleInfoRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiModuleInfoRegistry.class);
    private final SimpleBindingRuntimeContextService runtimeContext;
    private final SchemaContextProvider schemaContextProvider;
    private final ModuleInfoRegistry moduleInfoRegistry;
    @GuardedBy(value="this")
    private ServiceRegistration<?> registration;
    @GuardedBy(value="this")
    private long generation;

    OsgiModuleInfoRegistry(ModuleInfoRegistry moduleInfoRegistry, SchemaContextProvider schemaContextProvider, SimpleBindingRuntimeContextService runtimeContext) {
        this.moduleInfoRegistry = Objects.requireNonNull(moduleInfoRegistry);
        this.schemaContextProvider = Objects.requireNonNull(schemaContextProvider);
        this.runtimeContext = Objects.requireNonNull(runtimeContext);
    }

    synchronized void updateService() {
        SchemaContext context;
        try {
            context = this.schemaContextProvider.getSchemaContext();
        }
        catch (RuntimeException e) {
            LOG.error("Error updating the schema context", (Throwable)e);
            return;
        }
        try {
            this.runtimeContext.updateBindingRuntimeContext(context);
        }
        catch (RuntimeException e) {
            LOG.error("Error updating binding runtime context", (Throwable)e);
            return;
        }
    }

    public ObjectRegistration<YangModuleInfo> registerModuleInfo(YangModuleInfo yangModuleInfo) {
        return new ObjectRegistrationWrapper((ObjectRegistration<YangModuleInfo>)this.moduleInfoRegistry.registerModuleInfo(yangModuleInfo));
    }

    private class ObjectRegistrationWrapper
    implements ObjectRegistration<YangModuleInfo> {
        private final ObjectRegistration<YangModuleInfo> inner;

        ObjectRegistrationWrapper(ObjectRegistration<YangModuleInfo> inner) {
            this.inner = Objects.requireNonNull(inner);
        }

        public YangModuleInfo getInstance() {
            return (YangModuleInfo)this.inner.getInstance();
        }

        public void close() {
            try {
                this.inner.close();
            }
            finally {
                OsgiModuleInfoRegistry.this.updateService();
            }
        }

        public String toString() {
            return this.inner.toString();
        }
    }
}

