/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.osgi.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.mdsal.binding.dom.codec.osgi.impl.OsgiModuleInfoRegistry;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModuleInfoBundleTracker
implements BundleTrackerCustomizer<Collection<ObjectRegistration<YangModuleInfo>>> {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleInfoBundleTracker.class);
    private static final String MODULE_INFO_PROVIDER_PATH_PREFIX = "META-INF/services/";
    private static final String YANG_MODLE_BINDING_PROVIDER_SERVICE = "META-INF/services/" + YangModelBindingProvider.class.getName();
    private static final Pattern BRACE_PATTERN = Pattern.compile("{}", 16);
    private final OsgiModuleInfoRegistry moduleInfoRegistry;
    private volatile boolean starting = true;

    ModuleInfoBundleTracker(OsgiModuleInfoRegistry moduleInfoRegistry) {
        this.moduleInfoRegistry = Objects.requireNonNull(moduleInfoRegistry);
    }

    void finishStart() {
        this.starting = false;
        this.moduleInfoRegistry.updateService();
    }

    public Collection<ObjectRegistration<YangModuleInfo>> addingBundle(Bundle bundle, BundleEvent event) {
        List lines;
        URL resource = bundle.getEntry(YANG_MODLE_BINDING_PROVIDER_SERVICE);
        if (resource == null) {
            LOG.debug("Bundle {} does not have an entry for {}", (Object)bundle, (Object)YANG_MODLE_BINDING_PROVIDER_SERVICE);
            return ImmutableList.of();
        }
        LOG.debug("Got addingBundle({}) with YangModelBindingProvider resource {}", (Object)bundle, (Object)resource);
        try {
            lines = Resources.readLines((URL)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Error while reading {} from bundle {}", new Object[]{resource, bundle, e});
            return ImmutableList.of();
        }
        if (lines.isEmpty()) {
            LOG.debug("Bundle {} has empty services for {}", (Object)bundle, (Object)YANG_MODLE_BINDING_PROVIDER_SERVICE);
            return ImmutableList.of();
        }
        ArrayList<ObjectRegistration<YangModuleInfo>> registrations = new ArrayList<ObjectRegistration<YangModuleInfo>>(lines.size());
        for (String moduleInfoName : lines) {
            YangModuleInfo moduleInfo;
            LOG.trace("Retrieve ModuleInfo({}, {})", (Object)moduleInfoName, (Object)bundle);
            try {
                moduleInfo = ModuleInfoBundleTracker.retrieveModuleInfo(moduleInfoName, bundle);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to acquire {} from bundle {}, ignoring it", new Object[]{moduleInfoName, bundle, e});
                continue;
            }
            registrations.add(this.moduleInfoRegistry.registerModuleInfo(moduleInfo));
        }
        if (!this.starting) {
            this.moduleInfoRegistry.updateService();
        }
        LOG.trace("Bundle {} resultend in registrations {}", (Object)bundle, registrations);
        return registrations;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Collection<ObjectRegistration<YangModuleInfo>> object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Collection<ObjectRegistration<YangModuleInfo>> regs) {
        if (regs == null) {
            return;
        }
        for (ObjectRegistration<YangModuleInfo> reg : regs) {
            try {
                reg.close();
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister YangModuleInfo {}", reg.getInstance(), (Object)e);
            }
        }
    }

    private static YangModuleInfo retrieveModuleInfo(String moduleInfoClass, Bundle bundle) {
        YangModelBindingProvider instance;
        Class<?> clazz = ModuleInfoBundleTracker.loadClass(moduleInfoClass, bundle);
        if (!YangModelBindingProvider.class.isAssignableFrom(clazz)) {
            String errorMessage = ModuleInfoBundleTracker.logMessage("Class {} does not implement {} in bundle {}", clazz, YangModelBindingProvider.class, bundle);
            throw new IllegalStateException(errorMessage);
        }
        try {
            Object instanceObj = clazz.newInstance();
            instance = (YangModelBindingProvider)YangModelBindingProvider.class.cast(instanceObj);
        }
        catch (InstantiationException e) {
            String errorMessage = ModuleInfoBundleTracker.logMessage("Could not instantiate {} in bundle {}, reason {}", moduleInfoClass, bundle, e);
            throw new IllegalStateException(errorMessage, e);
        }
        catch (IllegalAccessException e) {
            String errorMessage = ModuleInfoBundleTracker.logMessage("Illegal access during instantiation of class {} in bundle {}, reason {}", moduleInfoClass, bundle, e);
            throw new IllegalStateException(errorMessage, e);
        }
        try {
            return instance.getModuleInfo();
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new IllegalStateException("Error while executing getModuleInfo on " + instance, e);
        }
    }

    private static Class<?> loadClass(String moduleInfoClass, Bundle bundle) {
        try {
            return bundle.loadClass(moduleInfoClass);
        }
        catch (ClassNotFoundException e) {
            String errorMessage = ModuleInfoBundleTracker.logMessage("Could not find class {} in bundle {}, reason {}", moduleInfoClass, bundle, e);
            throw new IllegalStateException(errorMessage);
        }
    }

    @SuppressFBWarnings(value={"SLF4J_UNKNOWN_ARRAY"})
    private static String logMessage(String slfMessage, Object ... params) {
        LOG.info(slfMessage, params);
        return String.format(BRACE_PATTERN.matcher(slfMessage).replaceAll("%s"), params);
    }
}

