/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.YangPatch;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.Edit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class YangPatchBuilder
implements Builder<YangPatch> {
    private String _comment;
    private List<Edit> _edit;
    private String _patchId;
    Map<Class<? extends Augmentation<YangPatch>>, Augmentation<YangPatch>> augmentation = Collections.emptyMap();

    public YangPatchBuilder() {
    }

    public YangPatchBuilder(YangPatch base) {
        Map aug;
        this._comment = base.getComment();
        this._edit = base.getEdit();
        this._patchId = base.getPatchId();
        if (base instanceof YangPatchImpl) {
            YangPatchImpl impl = (YangPatchImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<YangPatch>>, Augmentation<YangPatch>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YangPatch>>, Augmentation<YangPatch>>(aug);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public List<Edit> getEdit() {
        return this._edit;
    }

    public String getPatchId() {
        return this._patchId;
    }

    public <E$$ extends Augmentation<YangPatch>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void check_commentLength(String value) {
        int length = value.length();
        if (length >= 0 && length <= 1024) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[0..1024]]", (Object)value);
    }

    public YangPatchBuilder setComment(String value) {
        if (value != null) {
            YangPatchBuilder.check_commentLength(value);
        }
        this._comment = value;
        return this;
    }

    public YangPatchBuilder setEdit(List<Edit> values) {
        this._edit = values;
        return this;
    }

    public YangPatchBuilder setPatchId(String value) {
        this._patchId = value;
        return this;
    }

    public YangPatchBuilder addAugmentation(Class<? extends Augmentation<YangPatch>> augmentationType, Augmentation<YangPatch> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YangPatch>>, Augmentation<YangPatch>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public YangPatchBuilder removeAugmentation(Class<? extends Augmentation<YangPatch>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public YangPatch build() {
        return new YangPatchImpl(this);
    }

    private static final class YangPatchImpl
    implements YangPatch {
        private final String _comment;
        private final List<Edit> _edit;
        private final String _patchId;
        private Map<Class<? extends Augmentation<YangPatch>>, Augmentation<YangPatch>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        YangPatchImpl(YangPatchBuilder base) {
            this._comment = base.getComment();
            this._edit = base.getEdit();
            this._patchId = base.getPatchId();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<YangPatch> getImplementedInterface() {
            return YangPatch.class;
        }

        @Override
        public String getComment() {
            return this._comment;
        }

        @Override
        public List<Edit> getEdit() {
            return this._edit;
        }

        @Override
        public String getPatchId() {
            return this._patchId;
        }

        public <E$$ extends Augmentation<YangPatch>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._comment);
            result = 31 * result + Objects.hashCode(this._edit);
            result = 31 * result + Objects.hashCode(this._patchId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!YangPatch.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            YangPatch other = (YangPatch)obj;
            if (!Objects.equals(this._comment, other.getComment())) {
                return false;
            }
            if (!Objects.equals(this._edit, other.getEdit())) {
                return false;
            }
            if (!Objects.equals(this._patchId, other.getPatchId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                YangPatchImpl otherImpl = (YangPatchImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<YangPatch>>, Augmentation<YangPatch>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"YangPatch");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_comment", (Object)this._comment);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_edit", this._edit);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_patchId", (Object)this._patchId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

