/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.notification;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.notification.Notification;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NotificationBuilder
implements Builder<Notification> {
    private DateAndTime _eventTime;
    Map<Class<? extends Augmentation<Notification>>, Augmentation<Notification>> augmentation = Collections.emptyMap();

    public NotificationBuilder() {
    }

    public NotificationBuilder(Notification base) {
        Map aug;
        this._eventTime = base.getEventTime();
        if (base instanceof NotificationImpl) {
            NotificationImpl impl = (NotificationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Notification>>, Augmentation<Notification>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notification>>, Augmentation<Notification>>(aug);
        }
    }

    public DateAndTime getEventTime() {
        return this._eventTime;
    }

    public <E$$ extends Augmentation<Notification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NotificationBuilder setEventTime(DateAndTime value) {
        this._eventTime = value;
        return this;
    }

    public NotificationBuilder addAugmentation(Class<? extends Augmentation<Notification>> augmentationType, Augmentation<Notification> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notification>>, Augmentation<Notification>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NotificationBuilder removeAugmentation(Class<? extends Augmentation<Notification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Notification build() {
        return new NotificationImpl(this);
    }

    private static final class NotificationImpl
    implements Notification {
        private final DateAndTime _eventTime;
        private Map<Class<? extends Augmentation<Notification>>, Augmentation<Notification>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NotificationImpl(NotificationBuilder base) {
            this._eventTime = base.getEventTime();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Notification> getImplementedInterface() {
            return Notification.class;
        }

        @Override
        public DateAndTime getEventTime() {
            return this._eventTime;
        }

        public <E$$ extends Augmentation<Notification>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._eventTime);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Notification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Notification other = (Notification)obj;
            if (!Objects.equals(this._eventTime, other.getEventTime())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NotificationImpl otherImpl = (NotificationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Notification>>, Augmentation<Notification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Notification");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_eventTime", (Object)this._eventTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

