/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.errors;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.DataResourceIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.errors.Error;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.errors.error.ErrorInfo;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ErrorBuilder
implements Builder<Error> {
    private String _errorAppTag;
    private ErrorInfo _errorInfo;
    private String _errorMessage;
    private DataResourceIdentifier _errorPath;
    private String _errorTag;
    private Error.ErrorType _errorType;
    Map<Class<? extends Augmentation<Error>>, Augmentation<Error>> augmentation = Collections.emptyMap();

    public ErrorBuilder() {
    }

    public ErrorBuilder(Error base) {
        Map aug;
        this._errorAppTag = base.getErrorAppTag();
        this._errorInfo = base.getErrorInfo();
        this._errorMessage = base.getErrorMessage();
        this._errorPath = base.getErrorPath();
        this._errorTag = base.getErrorTag();
        this._errorType = base.getErrorType();
        if (base instanceof ErrorImpl) {
            ErrorImpl impl = (ErrorImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Error>>, Augmentation<Error>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Error>>, Augmentation<Error>>(aug);
        }
    }

    public String getErrorAppTag() {
        return this._errorAppTag;
    }

    public ErrorInfo getErrorInfo() {
        return this._errorInfo;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public DataResourceIdentifier getErrorPath() {
        return this._errorPath;
    }

    public String getErrorTag() {
        return this._errorTag;
    }

    public Error.ErrorType getErrorType() {
        return this._errorType;
    }

    public <E$$ extends Augmentation<Error>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ErrorBuilder setErrorAppTag(String value) {
        this._errorAppTag = value;
        return this;
    }

    public ErrorBuilder setErrorInfo(ErrorInfo value) {
        this._errorInfo = value;
        return this;
    }

    public ErrorBuilder setErrorMessage(String value) {
        this._errorMessage = value;
        return this;
    }

    public ErrorBuilder setErrorPath(DataResourceIdentifier value) {
        this._errorPath = value;
        return this;
    }

    public ErrorBuilder setErrorTag(String value) {
        this._errorTag = value;
        return this;
    }

    public ErrorBuilder setErrorType(Error.ErrorType value) {
        this._errorType = value;
        return this;
    }

    public ErrorBuilder addAugmentation(Class<? extends Augmentation<Error>> augmentationType, Augmentation<Error> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Error>>, Augmentation<Error>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ErrorBuilder removeAugmentation(Class<? extends Augmentation<Error>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Error build() {
        return new ErrorImpl(this);
    }

    private static final class ErrorImpl
    implements Error {
        private final String _errorAppTag;
        private final ErrorInfo _errorInfo;
        private final String _errorMessage;
        private final DataResourceIdentifier _errorPath;
        private final String _errorTag;
        private final Error.ErrorType _errorType;
        private Map<Class<? extends Augmentation<Error>>, Augmentation<Error>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ErrorImpl(ErrorBuilder base) {
            this._errorAppTag = base.getErrorAppTag();
            this._errorInfo = base.getErrorInfo();
            this._errorMessage = base.getErrorMessage();
            this._errorPath = base.getErrorPath();
            this._errorTag = base.getErrorTag();
            this._errorType = base.getErrorType();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Error> getImplementedInterface() {
            return Error.class;
        }

        @Override
        public String getErrorAppTag() {
            return this._errorAppTag;
        }

        @Override
        public ErrorInfo getErrorInfo() {
            return this._errorInfo;
        }

        @Override
        public String getErrorMessage() {
            return this._errorMessage;
        }

        @Override
        public DataResourceIdentifier getErrorPath() {
            return this._errorPath;
        }

        @Override
        public String getErrorTag() {
            return this._errorTag;
        }

        @Override
        public Error.ErrorType getErrorType() {
            return this._errorType;
        }

        public <E$$ extends Augmentation<Error>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._errorAppTag);
            result = 31 * result + Objects.hashCode(this._errorInfo);
            result = 31 * result + Objects.hashCode(this._errorMessage);
            result = 31 * result + Objects.hashCode(this._errorPath);
            result = 31 * result + Objects.hashCode(this._errorTag);
            result = 31 * result + Objects.hashCode((Object)this._errorType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Error.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Error other = (Error)obj;
            if (!Objects.equals(this._errorAppTag, other.getErrorAppTag())) {
                return false;
            }
            if (!Objects.equals(this._errorInfo, other.getErrorInfo())) {
                return false;
            }
            if (!Objects.equals(this._errorMessage, other.getErrorMessage())) {
                return false;
            }
            if (!Objects.equals(this._errorPath, other.getErrorPath())) {
                return false;
            }
            if (!Objects.equals(this._errorTag, other.getErrorTag())) {
                return false;
            }
            if (!Objects.equals((Object)this._errorType, (Object)other.getErrorType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ErrorImpl otherImpl = (ErrorImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Error>>, Augmentation<Error>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Error");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorAppTag", (Object)this._errorAppTag);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorInfo", (Object)this._errorInfo);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorMessage", (Object)this._errorMessage);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorPath", (Object)this._errorPath);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorTag", (Object)this._errorTag);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorType", (Object)((Object)this._errorType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

