/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.blueprint.impl;

import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.jpa.blueprint.impl.AnnotationScanner;
import org.apache.aries.jpa.blueprint.impl.JpaInterceptor;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.coordinator.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaComponentProcessor
implements ComponentDefinitionRegistryProcessor {
    private static final String JPA_COORDINATOR = "jpa_Coordinator";
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaComponentProcessor.class);
    private AnnotationScanner annotationScanner = new AnnotationScanner();
    private ParserContext pc;

    public void setPc(ParserContext pc) {
        this.pc = pc;
    }

    public void process(ComponentDefinitionRegistry cdr) {
        BlueprintContainer container = (BlueprintContainer)JpaComponentProcessor.getComponent(cdr, "blueprintContainer");
        Bundle bundle = (Bundle)JpaComponentProcessor.getComponent(cdr, "blueprintBundle");
        cdr.registerComponentDefinition(this.createServiceRef(JPA_COORDINATOR, Coordinator.class));
        HashSet components = new HashSet(cdr.getComponentDefinitionNames());
        for (String component : components) {
            MutableServiceMetadata sMeta;
            Target target;
            ComponentMetadata compDef = cdr.getComponentDefinition(component);
            if (compDef instanceof MutableBeanMetadata && !((MutableBeanMetadata)compDef).isProcessor()) {
                this.handleComponent((MutableBeanMetadata)compDef, bundle, cdr, container);
                continue;
            }
            if (!(compDef instanceof MutableServiceMetadata) || !((target = (sMeta = (MutableServiceMetadata)compDef).getServiceComponent()) instanceof MutableBeanMetadata)) continue;
            this.handleComponent((MutableBeanMetadata)target, bundle, cdr, container);
        }
    }

    private void handleComponent(MutableBeanMetadata compDef, Bundle bundle, ComponentDefinitionRegistry cdr, BlueprintContainer container) {
        Class compClass;
        String compName = compDef.getId();
        if (compDef.getClassName() == null) {
            LOGGER.debug("No classname for " + compDef.getId());
            return;
        }
        try {
            compClass = bundle.loadClass(compDef.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Bean class not found " + compDef.getClassName(), e);
        }
        compDef.setFieldInjection(true);
        List<AccessibleObject> pcMembers = this.annotationScanner.getJpaAnnotatedMembers(compClass, PersistenceContext.class);
        for (AccessibleObject member : pcMembers) {
            PersistenceContext pcAnn = member.getAnnotation(PersistenceContext.class);
            String propName = AnnotationScanner.getName(member);
            Class<?> iface = AnnotationScanner.getType(member);
            LOGGER.debug("Injecting {} into prop {} of bean {} with class {}", new Object[]{iface.getSimpleName(), propName, compName, compClass});
            MutableRefMetadata ref = this.getServiceRef(cdr, pcAnn.unitName(), iface);
            compDef.addProperty(propName, (Metadata)ref);
            MutableRefMetadata emRef = this.getServiceRef(cdr, pcAnn.unitName(), EntityManager.class);
            JpaInterceptor interceptor = new JpaInterceptor(container, JPA_COORDINATOR, emRef.getComponentId());
            cdr.registerInterceptorWithComponent((ComponentMetadata)compDef, (Interceptor)interceptor);
        }
        List<AccessibleObject> puMembers = this.annotationScanner.getJpaAnnotatedMembers(compClass, PersistenceUnit.class);
        for (AccessibleObject member : puMembers) {
            PersistenceUnit puAnn = member.getAnnotation(PersistenceUnit.class);
            String propName = AnnotationScanner.getName(member);
            Class<?> iface = AnnotationScanner.getType(member);
            LOGGER.debug("Injecting {} into prop {} of bean {} with class {}", new Object[]{iface.getSimpleName(), propName, compName, compClass});
            MutableRefMetadata ref = this.getServiceRef(cdr, puAnn.unitName(), iface);
            compDef.addProperty(propName, (Metadata)ref);
        }
    }

    private MutableRefMetadata getServiceRef(ComponentDefinitionRegistry cdr, String unitName, Class<?> iface) {
        ComponentMetadata serviceRef = cdr.getComponentDefinition(this.getId(unitName, iface));
        if (serviceRef == null) {
            serviceRef = this.createJPAServiceRef(unitName, iface);
            cdr.registerComponentDefinition(serviceRef);
        }
        MutableRefMetadata ref = (MutableRefMetadata)this.pc.createMetadata(MutableRefMetadata.class);
        ref.setComponentId(serviceRef.getId());
        return ref;
    }

    private ComponentMetadata createServiceRef(String id, Class<?> iface) {
        MutableReferenceMetadata refMeta = (MutableReferenceMetadata)this.pc.createMetadata(MutableReferenceMetadata.class);
        refMeta.setActivation(JpaComponentProcessor.getDefaultActivation(this.pc));
        refMeta.setAvailability(1);
        refMeta.setRuntimeInterface(iface);
        refMeta.setTimeout((long)Integer.parseInt(this.pc.getDefaultTimeout()));
        List emptyList = Collections.emptyList();
        refMeta.setDependsOn(emptyList);
        refMeta.setId(id);
        return refMeta;
    }

    private ComponentMetadata createJPAServiceRef(String unitName, Class<?> iface) {
        MutableReferenceMetadata refMeta = (MutableReferenceMetadata)this.pc.createMetadata(MutableReferenceMetadata.class);
        refMeta.setActivation(JpaComponentProcessor.getDefaultActivation(this.pc));
        refMeta.setAvailability(1);
        refMeta.setRuntimeInterface(iface);
        refMeta.setFilter(String.format("(%s=%s)", "osgi.unit.name", unitName));
        refMeta.setTimeout((long)Integer.parseInt(this.pc.getDefaultTimeout()));
        List emptyList = Collections.emptyList();
        refMeta.setDependsOn(emptyList);
        refMeta.setId(this.getId(unitName, iface));
        return refMeta;
    }

    public String getId(String unitName, Class<?> iface) {
        return unitName + "-" + iface.getSimpleName();
    }

    private static int getDefaultActivation(ParserContext ctx) {
        return "ACTIVATION_EAGER".equalsIgnoreCase(ctx.getDefaultActivation()) ? 1 : 2;
    }

    private static <T> T getComponent(ComponentDefinitionRegistry cdr, String id) {
        return (T)((PassThroughMetadata)cdr.getComponentDefinition(id)).getObject();
    }
}

