/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AaaEncryptServiceConfigBuilder
implements Builder<AaaEncryptServiceConfig> {
    private String _cipherTransforms;
    private Integer _encryptIterationCount;
    private String _encryptKey;
    private Integer _encryptKeyLength;
    private String _encryptMethod;
    private String _encryptSalt;
    private String _encryptType;
    private Integer _passwordLength;
    Map<Class<? extends Augmentation<AaaEncryptServiceConfig>>, Augmentation<AaaEncryptServiceConfig>> augmentation = Collections.emptyMap();

    public AaaEncryptServiceConfigBuilder() {
    }

    public AaaEncryptServiceConfigBuilder(AaaEncryptServiceConfig base) {
        Map aug;
        this._cipherTransforms = base.getCipherTransforms();
        this._encryptIterationCount = base.getEncryptIterationCount();
        this._encryptKey = base.getEncryptKey();
        this._encryptKeyLength = base.getEncryptKeyLength();
        this._encryptMethod = base.getEncryptMethod();
        this._encryptSalt = base.getEncryptSalt();
        this._encryptType = base.getEncryptType();
        this._passwordLength = base.getPasswordLength();
        if (base instanceof AaaEncryptServiceConfigImpl) {
            AaaEncryptServiceConfigImpl impl = (AaaEncryptServiceConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AaaEncryptServiceConfig>>, Augmentation<AaaEncryptServiceConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AaaEncryptServiceConfig>>, Augmentation<AaaEncryptServiceConfig>>(aug);
        }
    }

    public String getCipherTransforms() {
        return this._cipherTransforms;
    }

    public Integer getEncryptIterationCount() {
        return this._encryptIterationCount;
    }

    public String getEncryptKey() {
        return this._encryptKey;
    }

    public Integer getEncryptKeyLength() {
        return this._encryptKeyLength;
    }

    public String getEncryptMethod() {
        return this._encryptMethod;
    }

    public String getEncryptSalt() {
        return this._encryptSalt;
    }

    public String getEncryptType() {
        return this._encryptType;
    }

    public Integer getPasswordLength() {
        return this._passwordLength;
    }

    public <E$$ extends Augmentation<AaaEncryptServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AaaEncryptServiceConfigBuilder setCipherTransforms(String value) {
        this._cipherTransforms = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder setEncryptIterationCount(Integer value) {
        this._encryptIterationCount = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder setEncryptKey(String value) {
        this._encryptKey = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder setEncryptKeyLength(Integer value) {
        this._encryptKeyLength = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder setEncryptMethod(String value) {
        this._encryptMethod = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder setEncryptSalt(String value) {
        this._encryptSalt = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder setEncryptType(String value) {
        this._encryptType = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder setPasswordLength(Integer value) {
        this._passwordLength = value;
        return this;
    }

    public AaaEncryptServiceConfigBuilder addAugmentation(Class<? extends Augmentation<AaaEncryptServiceConfig>> augmentationType, Augmentation<AaaEncryptServiceConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AaaEncryptServiceConfig>>, Augmentation<AaaEncryptServiceConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AaaEncryptServiceConfigBuilder removeAugmentation(Class<? extends Augmentation<AaaEncryptServiceConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AaaEncryptServiceConfig build() {
        return new AaaEncryptServiceConfigImpl(this);
    }

    private static final class AaaEncryptServiceConfigImpl
    implements AaaEncryptServiceConfig {
        private final String _cipherTransforms;
        private final Integer _encryptIterationCount;
        private final String _encryptKey;
        private final Integer _encryptKeyLength;
        private final String _encryptMethod;
        private final String _encryptSalt;
        private final String _encryptType;
        private final Integer _passwordLength;
        private Map<Class<? extends Augmentation<AaaEncryptServiceConfig>>, Augmentation<AaaEncryptServiceConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AaaEncryptServiceConfigImpl(AaaEncryptServiceConfigBuilder base) {
            this._cipherTransforms = base.getCipherTransforms();
            this._encryptIterationCount = base.getEncryptIterationCount();
            this._encryptKey = base.getEncryptKey();
            this._encryptKeyLength = base.getEncryptKeyLength();
            this._encryptMethod = base.getEncryptMethod();
            this._encryptSalt = base.getEncryptSalt();
            this._encryptType = base.getEncryptType();
            this._passwordLength = base.getPasswordLength();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<AaaEncryptServiceConfig> getImplementedInterface() {
            return AaaEncryptServiceConfig.class;
        }

        @Override
        public String getCipherTransforms() {
            return this._cipherTransforms;
        }

        @Override
        public Integer getEncryptIterationCount() {
            return this._encryptIterationCount;
        }

        @Override
        public String getEncryptKey() {
            return this._encryptKey;
        }

        @Override
        public Integer getEncryptKeyLength() {
            return this._encryptKeyLength;
        }

        @Override
        public String getEncryptMethod() {
            return this._encryptMethod;
        }

        @Override
        public String getEncryptSalt() {
            return this._encryptSalt;
        }

        @Override
        public String getEncryptType() {
            return this._encryptType;
        }

        @Override
        public Integer getPasswordLength() {
            return this._passwordLength;
        }

        public <E$$ extends Augmentation<AaaEncryptServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._cipherTransforms);
            result = 31 * result + Objects.hashCode(this._encryptIterationCount);
            result = 31 * result + Objects.hashCode(this._encryptKey);
            result = 31 * result + Objects.hashCode(this._encryptKeyLength);
            result = 31 * result + Objects.hashCode(this._encryptMethod);
            result = 31 * result + Objects.hashCode(this._encryptSalt);
            result = 31 * result + Objects.hashCode(this._encryptType);
            result = 31 * result + Objects.hashCode(this._passwordLength);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AaaEncryptServiceConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AaaEncryptServiceConfig other = (AaaEncryptServiceConfig)obj;
            if (!Objects.equals(this._cipherTransforms, other.getCipherTransforms())) {
                return false;
            }
            if (!Objects.equals(this._encryptIterationCount, other.getEncryptIterationCount())) {
                return false;
            }
            if (!Objects.equals(this._encryptKey, other.getEncryptKey())) {
                return false;
            }
            if (!Objects.equals(this._encryptKeyLength, other.getEncryptKeyLength())) {
                return false;
            }
            if (!Objects.equals(this._encryptMethod, other.getEncryptMethod())) {
                return false;
            }
            if (!Objects.equals(this._encryptSalt, other.getEncryptSalt())) {
                return false;
            }
            if (!Objects.equals(this._encryptType, other.getEncryptType())) {
                return false;
            }
            if (!Objects.equals(this._passwordLength, other.getPasswordLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AaaEncryptServiceConfigImpl otherImpl = (AaaEncryptServiceConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AaaEncryptServiceConfig>>, Augmentation<AaaEncryptServiceConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"AaaEncryptServiceConfig");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_cipherTransforms", (Object)this._cipherTransforms);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encryptIterationCount", (Object)this._encryptIterationCount);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encryptKey", (Object)this._encryptKey);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encryptKeyLength", (Object)this._encryptKeyLength);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encryptMethod", (Object)this._encryptMethod);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encryptSalt", (Object)this._encryptSalt);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encryptType", (Object)this._encryptType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_passwordLength", (Object)this._passwordLength);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

