/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ReflectionBasedCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.UnionValueOptionContext;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.yang.types.BaseYangTypes;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

final class UnionTypeCodec
extends ReflectionBasedCodec {
    private final ImmutableSet<UnionValueOptionContext> typeCodecs;

    private UnionTypeCodec(Class<?> unionCls, Set<UnionValueOptionContext> codecs) {
        super(unionCls);
        this.typeCodecs = ImmutableSet.copyOf(codecs);
    }

    static Callable<UnionTypeCodec> loader(Class<?> unionCls, UnionTypeDefinition unionType, BindingCodecContext bindingCodecContext) {
        return () -> {
            LinkedHashSet<UnionValueOptionContext> values = new LinkedHashSet<UnionValueOptionContext>();
            for (TypeDefinition subtype : unionType.getTypes()) {
                if (subtype instanceof LeafrefTypeDefinition) {
                    UnionTypeCodec.addLeafrefValueCodec(unionCls, unionType, bindingCodecContext, values, subtype);
                    continue;
                }
                Method valueGetter = unionCls.getMethod("get" + BindingMapping.getClassName((QName)subtype.getQName()), new Class[0]);
                Class<?> valueType = valueGetter.getReturnType();
                Codec<Object, Object> valueCodec = bindingCodecContext.getCodec(valueType, subtype);
                values.add(new UnionValueOptionContext(unionCls, valueType, valueGetter, valueCodec));
            }
            return new UnionTypeCodec(unionCls, values);
        };
    }

    private static void addLeafrefValueCodec(Class<?> unionCls, UnionTypeDefinition unionType, BindingCodecContext bindingCodecContext, Set<UnionValueOptionContext> values, TypeDefinition<?> subtype) throws NoSuchMethodException {
        SchemaContext schemaContext = bindingCodecContext.getRuntimeContext().getSchemaContext();
        Module module = (Module)schemaContext.findModule(subtype.getQName().getModule()).get();
        RevisionAwareXPath xpath = ((LeafrefTypeDefinition)subtype).getPathStatement();
        SchemaNode dataNode = xpath.isAbsolute() ? SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (Module)module, (RevisionAwareXPath)xpath) : SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)schemaContext, (Module)module, (SchemaNode)unionType, (RevisionAwareXPath)xpath);
        String className = BindingMapping.getClassName((String)unionCls.getSimpleName());
        LeafSchemaNode typeNode = (LeafSchemaNode)dataNode;
        String typeName = BindingMapping.getClassName((String)BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(typeNode.getType(), (SchemaNode)typeNode).getName());
        Method valueGetterParent = unionCls.getMethod("get" + typeName + className + "Value", new Class[0]);
        Class<?> returnType = valueGetterParent.getReturnType();
        Codec<Object, Object> valueCodec = bindingCodecContext.getCodec(returnType, subtype);
        values.add(new UnionValueOptionContext(unionCls, returnType, valueGetterParent, valueCodec));
    }

    public Object deserialize(Object input) {
        for (UnionValueOptionContext member : this.typeCodecs) {
            Object ret = member.deserializeUnion(input);
            if (ret == null) continue;
            return ret;
        }
        throw new IllegalArgumentException(String.format("Failed to construct instance of %s for input %s", this.getTypeClass(), input));
    }

    public Object serialize(Object input) {
        if (input != null) {
            for (UnionValueOptionContext valCtx : this.typeCodecs) {
                Object domValue = valCtx.serialize(input);
                if (domValue == null) continue;
                return domValue;
            }
        }
        return null;
    }
}

