/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

class ListNodeCodecContext<D extends DataObject>
extends DataObjectCodecContext<D, ListSchemaNode> {
    protected ListNodeCodecContext(DataContainerCodecPrototype<ListSchemaNode> prototype) {
        super(prototype);
    }

    @Override
    public D deserialize(NormalizedNode<?, ?> node) {
        if (node instanceof MapEntryNode) {
            return this.fromMapEntry((MapEntryNode)node);
        }
        if (node instanceof UnkeyedListEntryNode) {
            return this.fromUnkeyedListEntry((UnkeyedListEntryNode)node);
        }
        throw new IllegalStateException("Unsupported data type " + node.getClass());
    }

    @Override
    protected Object deserializeObject(NormalizedNode<?, ?> node) {
        if (node instanceof MapNode) {
            return this.fromMap((MapNode)node);
        }
        if (node instanceof MapEntryNode) {
            return this.fromMapEntry((MapEntryNode)node);
        }
        if (node instanceof UnkeyedListNode) {
            return this.fromUnkeyedList((UnkeyedListNode)node);
        }
        if (node instanceof UnkeyedListEntryNode) {
            return this.fromUnkeyedListEntry((UnkeyedListEntryNode)node);
        }
        throw new IllegalStateException("Unsupported data type " + node.getClass());
    }

    private List<D> fromMap(MapNode nodes) {
        ArrayList<D> ret = new ArrayList<D>(nodes.getValue().size());
        for (MapEntryNode node : nodes.getValue()) {
            ret.add(this.fromMapEntry(node));
        }
        return ret;
    }

    private D fromMapEntry(MapEntryNode node) {
        return this.createBindingProxy((NormalizedNodeContainer<?, ?, ?>)node);
    }

    private D fromUnkeyedListEntry(UnkeyedListEntryNode node) {
        return this.createBindingProxy((NormalizedNodeContainer<?, ?, ?>)node);
    }

    private List<D> fromUnkeyedList(UnkeyedListNode nodes) {
        ArrayList<D> ret = new ArrayList<D>(((Collection)nodes.getValue()).size());
        for (UnkeyedListEntryNode node : (Collection)nodes.getValue()) {
            ret.add(this.fromUnkeyedListEntry(node));
        }
        return ret;
    }
}

