/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;

final class LeafNodeCodecContext<D extends DataObject>
extends NodeCodecContext<D>
implements NodeContextSupplier {
    private final YangInstanceIdentifier.PathArgument yangIdentifier;
    private final Codec<Object, Object> valueCodec;
    private final Method getter;
    private final DataSchemaNode schema;
    private final Object defaultObject;

    LeafNodeCodecContext(DataSchemaNode schema, Codec<Object, Object> codec, Method getter, SchemaContext schemaContext) {
        this.yangIdentifier = new YangInstanceIdentifier.NodeIdentifier(schema.getQName());
        this.valueCodec = Objects.requireNonNull(codec);
        this.getter = getter;
        this.schema = Objects.requireNonNull(schema);
        this.defaultObject = LeafNodeCodecContext.createDefaultObject(schema, this.valueCodec, schemaContext);
    }

    private static Object createDefaultObject(DataSchemaNode schema, Codec<Object, Object> codec, SchemaContext schemaContext) {
        if (schema instanceof LeafSchemaNode) {
            Optional defaultValue = ((LeafSchemaNode)schema).getType().getDefaultValue();
            TypeDefinition type = ((LeafSchemaNode)schema).getType();
            if (defaultValue.isPresent()) {
                if (type instanceof IdentityrefTypeDefinition) {
                    return LeafNodeCodecContext.qnameDomValueFromString(codec, schema, (String)defaultValue.get(), schemaContext);
                }
                return LeafNodeCodecContext.domValueFromString(codec, type, defaultValue.get());
            }
            while (type.getBaseType() != null && !type.getDefaultValue().isPresent()) {
                type = type.getBaseType();
            }
            defaultValue = type.getDefaultValue();
            if (defaultValue.isPresent()) {
                if (type instanceof IdentityrefTypeDefinition) {
                    return LeafNodeCodecContext.qnameDomValueFromString(codec, schema, (String)defaultValue.get(), schemaContext);
                }
                return LeafNodeCodecContext.domValueFromString(codec, type, defaultValue);
            }
        }
        return null;
    }

    private static Object qnameDomValueFromString(Codec<Object, Object> codec, DataSchemaNode schema, String defaultValue, SchemaContext schemaContext) {
        int prefixEndIndex = defaultValue.indexOf(58);
        if (prefixEndIndex != -1) {
            String defaultValuePrefix = defaultValue.substring(0, prefixEndIndex);
            Module module = (Module)schemaContext.findModule(schema.getQName().getModule()).get();
            if (module.getPrefix().equals(defaultValuePrefix)) {
                QName qname = QName.create((QNameModule)module.getQNameModule(), (String)defaultValue.substring(prefixEndIndex + 1));
                return codec.deserialize((Object)qname);
            }
            Set imports = module.getImports();
            for (ModuleImport moduleImport : imports) {
                if (!moduleImport.getPrefix().equals(defaultValuePrefix)) continue;
                Module importedModule = (Module)schemaContext.findModule(moduleImport.getModuleName(), moduleImport.getRevision()).get();
                QName qname = QName.create((QNameModule)importedModule.getQNameModule(), (String)defaultValue.substring(prefixEndIndex + 1));
                return codec.deserialize((Object)qname);
            }
            return null;
        }
        QName qname = QName.create((QName)schema.getQName(), (String)defaultValue);
        return codec.deserialize((Object)qname);
    }

    private static Object domValueFromString(Codec<Object, Object> codec, TypeDefinition<?> type, Object defaultValue) {
        TypeDefinitionAwareCodec typeDefAwareCodec = TypeDefinitionAwareCodec.from(type);
        if (typeDefAwareCodec != null) {
            Object castedDefaultValue = typeDefAwareCodec.deserialize((String)defaultValue);
            return codec.deserialize(castedDefaultValue);
        }
        return null;
    }

    @Override
    protected YangInstanceIdentifier.PathArgument getDomPathArgument() {
        return this.yangIdentifier;
    }

    protected Codec<Object, Object> getValueCodec() {
        return this.valueCodec;
    }

    @Override
    public D deserialize(NormalizedNode<?, ?> normalizedNode) {
        throw new UnsupportedOperationException("Leaf can not be deserialized to DataObject");
    }

    @Override
    public NodeCodecContext<?> get() {
        return this;
    }

    Method getGetter() {
        return this.getter;
    }

    @Override
    public BindingCodecTreeNode<?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        throw new IllegalArgumentException("Leaf does not have children");
    }

    @Override
    public BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends DataObject>> cacheSpecifier) {
        throw new UnsupportedOperationException("Leaves does not support caching codec.");
    }

    @Override
    public Class<D> getBindingClass() {
        throw new UnsupportedOperationException("Leaf does not have DataObject representation");
    }

    @Override
    public NormalizedNode<?, ?> serialize(D data) {
        throw new UnsupportedOperationException("Separete serialization of leaf node is not supported.");
    }

    @Override
    public void writeAsNormalizedNode(D data, NormalizedNodeStreamWriter writer) {
        throw new UnsupportedOperationException("Separete serialization of leaf node is not supported.");
    }

    @Override
    public <E extends DataObject> BindingCodecTreeNode<E> streamChild(Class<E> childClass) {
        throw new IllegalArgumentException("Leaf does not have children");
    }

    @Override
    public <E extends DataObject> Optional<? extends BindingCodecTreeNode<E>> possibleStreamChild(Class<E> childClass) {
        throw new IllegalArgumentException("Leaf does not have children");
    }

    @Override
    public BindingCodecTreeNode<?> yangPathArgumentChild(YangInstanceIdentifier.PathArgument child) {
        throw new IllegalArgumentException("Leaf does not have children");
    }

    @Override
    protected Object deserializeObject(NormalizedNode<?, ?> normalizedNode) {
        if (normalizedNode instanceof LeafNode) {
            return this.valueCodec.deserialize(normalizedNode.getValue());
        }
        if (normalizedNode instanceof LeafSetNode) {
            Collection domValues = ((LeafSetNode)normalizedNode).getValue();
            ArrayList<Object> result = new ArrayList<Object>(domValues.size());
            for (LeafSetEntryNode valueNode : domValues) {
                result.add(this.valueCodec.deserialize(valueNode.getValue()));
            }
            return result;
        }
        return null;
    }

    @Override
    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals(arg));
        return null;
    }

    @Override
    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        return this.getDomPathArgument();
    }

    public DataSchemaNode getSchema() {
        return this.schema;
    }

    @Override
    public BindingCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return BindingCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
    }

    @Override
    Object defaultObject() {
        return this.defaultObject;
    }
}

