/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class InstanceIdentifierCodec
implements Codec<YangInstanceIdentifier, InstanceIdentifier<?>> {
    private final BindingCodecContext context;

    InstanceIdentifierCodec(BindingCodecContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public YangInstanceIdentifier serialize(InstanceIdentifier<?> input) {
        ArrayList<YangInstanceIdentifier.PathArgument> domArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        this.context.getCodecContextNode(input, domArgs);
        return YangInstanceIdentifier.create(domArgs);
    }

    public InstanceIdentifier<?> deserialize(YangInstanceIdentifier input) {
        ArrayList<InstanceIdentifier.PathArgument> builder = new ArrayList<InstanceIdentifier.PathArgument>();
        NodeCodecContext<?> codec = this.context.getCodecContextNode(input, builder);
        if (codec == null) {
            return null;
        }
        if (codec instanceof ListNodeCodecContext && Iterables.getLast(builder) instanceof InstanceIdentifier.Item) {
            return null;
        }
        return InstanceIdentifier.create(builder);
    }
}

